% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_GroupwiseDEPlot.R
\name{do_GroupwiseDEPlot}
\alias{do_GroupwiseDEPlot}
\title{Compute a heatmap with the results of a group-wise DE analysis.}
\usage{
do_GroupwiseDEPlot(
  sample,
  de_genes,
  group.by = "seurat_clusters",
  viridis_map_pvalues = "B",
  viridis_map_logfc = "D",
  viridis_map_expression = "G",
  heatmap.legend.length = 75,
  heatmap.legend.width = 5,
  heatmap.legend.framecolor = "black",
  top_genes = 5,
  viridis_direction = -1,
  row_title_p_values = "",
  row_title_logfc = "Clusters",
  row_title_expression = c(""),
  column_title = "DE genes",
  heatmap_gap = 0.5,
  legend_gap = 1,
  assay = "SCT",
  slot = "data",
  legend.position = "bottom",
  row_names_side = "right",
  row_title_side = "left",
  row_title_rot = 90,
  cell_size = 5
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{de_genes}{\strong{\code{\link[tibble]{tibble}}} | DE genes matrix resulting of running \code{Seurat::FindAllMarkers()}.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{viridis_map_pvalues, viridis_map_logfc, viridis_map_expression}{\strong{\code{\link[base]{character}}} | Viridis color map for the heatmap of p-values, logFC or expression. One of A, B, C, D, E, F, G, H.}

\item{heatmap.legend.length, heatmap.legend.width}{\strong{\code{\link[base]{numeric}}} | Width and length of the legend in the heatmap.}

\item{heatmap.legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the edges and ticks of the legend in the heatmap.}

\item{top_genes}{\strong{\code{\link[base]{numeric}}} | Top N differentially expressed (DE) genes by group to retrieve.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{row_title_p_values}{\strong{\code{\link[base]{character}}} | Row title for the p-value heatmap. Blank by default.}

\item{row_title_logfc}{\strong{\code{\link[base]{character}}} | Row title for the logfc heatmap. Clusters by default.}

\item{row_title_expression}{\strong{\code{\link[base]{character}}} | Vector of titles of equal length as group.by.}

\item{column_title}{\strong{\code{\link[base]{character}}} | Title for the columns of the heatmaps. Only works with single heatmaps.}

\item{heatmap_gap}{\strong{\code{\link[base]{numeric}}} | Gap in cm between heatmaps.}

\item{legend_gap}{\strong{\code{\link[base]{numeric}}} | Gap in cm between legends.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{row_names_side}{\strong{\code{\link[base]{character}}} | Side to put the row names. Either left or right.}

\item{row_title_side}{\strong{\code{\link[base]{character}}} | Side to put the row titles Either left or right.}

\item{row_title_rot}{\strong{\code{\link[base]{numeric}}} | Degree in which to rotate the row titles.}

\item{cell_size}{\strong{\code{\link[base]{numeric}}} | Size of each cell in the heatmap.}
}
\value{
A heatmap composed of 3 main panels: -log10(adjusted p-value), log2(FC) and mean expression by cluster.
}
\description{
Compute a heatmap with the results of a group-wise DE analysis.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_GroupwiseDEPlot", passive = TRUE)

  if (isTRUE(value)){
    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Compute DE genes and transform to a tibble.
    de_genes <- readRDS(system.file("extdata/de_genes_example.rds", package = "SCpubr"))

    # Default output.
    p <- SCpubr::do_GroupwiseDEPlot(sample = sample,
                                    de_genes = de_genes)

    p

    # Increase the number of top DE genes by cluster.
    p <- SCpubr::do_GroupwiseDEPlot(sample = sample,
                                    de_genes = de_genes,
                                    top_genes = 2)

    p

    # Modify the row and column titles and the rotation.
    p <- SCpubr::do_GroupwiseDEPlot(sample = sample,
                                    de_genes = de_genes,
                                    column_title = "Title A",
                                    row_title_p_values = "Title B",
                                    row_title_logfc = "Title C",
                                    row_title_expression = "Title D",
                                    row_title_rot = 0)

    p

    sample$modified_orig.ident <- sample(x = c("Sample_A", "Sample_B", "Sample_C"),
                                         size = ncol(sample),
                                         replace = TRUE,
                                         prob = c(0.2, 0.7, 0.1))

    # Add more layers of mean expression with group.by.
    p <- SCpubr::do_GroupwiseDEPlot(sample = sample,
                                    de_genes = de_genes,
                                    group.by = c("seurat_clusters",
                                                 "modified_orig.ident",
                                                 "orig.ident"),
                                    row_title_expression = c("",
                                                             "Title A",
                                                             "Title B"))

    p

    # Change the viridis scales.
    p <- SCpubr::do_GroupwiseDEPlot(sample = sample,
                                    de_genes = de_genes,
                                    viridis_map_pvalues = "C",
                                    viridis_map_logfc = "E",
                                    viridis_map_expression = "D")

    p
  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
