% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{CVP_ADMM}
\alias{CVP_ADMM}
\title{Parallel CV (uses CVP_ADMMc)}
\usage{
CVP_ADMM(X, Y = NULL, A = diag(ncol(X)), B = diag(ncol(X)),
  C = diag(ncol(X)), lam = 10^seq(-2, 2, 0.2), alpha = 1, tau = 10,
  rho = 2, mu = 10, tau.rho = 2, iter.rho = 10, crit = c("ADMM",
  "loglik"), tol.abs = 1e-04, tol.rel = 1e-04, maxit = 1000,
  adjmaxit = NULL, K = 5, crit.cv = c("MSE", "loglik", "penloglik", "AIC",
  "BIC"), start = c("warm", "cold"), cores = 1, trace = c("progress",
  "print", "none"))
}
\arguments{
\item{X}{nxp data matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.}

\item{Y}{option to provide nxr response matrix. Each row corresponds to a single response and each column contains n response of a single feature/response.}

\item{A}{option to provide user-specified matrix for penalty term. This matrix must have p columns. Defaults to identity matrix.}

\item{B}{option to provide user-specified matrix for penalty term. This matrix must have p rows. Defaults to identity matrix.}

\item{C}{option to provide user-specified matrix for penalty term. This matrix must have nrow(A) rows and ncol(B) columns. Defaults to identity matrix.}

\item{lam}{positive tuning parameters for elastic net penalty. If a vector of parameters is provided, they should be in increasing order. Defaults to grid of values \code{10^seq(-2, 2, 0.2)}.}

\item{alpha}{elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. Alpha must be a single value (cross validation across alpha not supported).}

\item{tau}{optional constant used to ensure positive definiteness in Q matrix in algorithm}

\item{rho}{initial step size for ADMM algorithm.}

\item{mu}{factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.}

\item{tau.rho}{factor in which to increase/decrease step size \code{rho}}

\item{iter.rho}{step size \code{rho} will be updated every \code{iter.rho} steps}

\item{crit}{criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.}

\item{tol.abs}{absolute convergence tolerance. Defaults to 1e-4.}

\item{tol.rel}{relative convergence tolerance. Defaults to 1e-4.}

\item{maxit}{maximum number of iterations. Defaults to 1e3.}

\item{adjmaxit}{adjusted maximum number of iterations. During cross validation this option allows the user to adjust the maximum number of iterations after the first \code{lam} tuning parameter has converged. This option is intended to be paired with \code{warm} starts and allows for 'one-step' estimators. Defaults to NULL.}

\item{K}{specify the number of folds for cross validation.}

\item{crit.cv}{cross validation criterion (\code{MSE}, \code{loglik}, \code{penloglik}, \code{AIC}, or \code{BIC}). Defaults to \code{MSE}.}

\item{start}{specify \code{warm} or \code{cold} start for cross validation. Default is \code{warm}.}

\item{cores}{option to run CV in parallel. Defaults to \code{cores = 1}.}

\item{trace}{option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.}
}
\value{
returns list of returns which includes:
\item{lam}{optimal tuning parameter.}
\item{min.error}{minimum average cross validation error (cv.crit) for optimal parameters.}
\item{avg.error}{average cross validation error (cv.crit) across all folds.}
\item{cv.error}{cross validation errors (cv.crit).}
}
\description{
Parallel implementation of cross validation.
}
\keyword{internal}
