% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{draw_trajectory_heatmap}
\alias{draw_trajectory_heatmap}
\title{Draw time-series heatmap}
\usage{
draw_trajectory_heatmap(
  x,
  time,
  progression_group = NULL,
  modules = NULL,
  show_labels_row = FALSE,
  show_labels_col = FALSE,
  scale_features = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric matrix or data frame with one row per sample and one column per feature.}

\item{time}{A numeric vector containing the inferred time points of each sample along a trajectory.}

\item{progression_group}{\code{NULL} or a vector (or factor) containing the groupings of the samples (default \code{NULL}).}

\item{modules}{\code{NULL} or a data frame as returned by \code{\link{extract_modules}}.}

\item{show_labels_row}{\code{TRUE} if the labels of the rows are to be plotted (default \code{FALSE}).}

\item{show_labels_col}{\code{TRUE} if the labels of the cols are to be plotted (default \code{FALSE}).}

\item{scale_features}{\code{TRUE} if the values of each feature is to be scaled (default \code{TRUE}).}

\item{...}{Optional arguments to \code{\link[pheatmap]{pheatmap}}}
}
\value{
The output of the \code{\link[pheatmap]{pheatmap}} function.
}
\description{
\code{draw_trajectory_heatmap} draws a heatmap in which the samples
are ranked according their position in an inferred trajectory. In addition, the progression groups and
feature modules can be passed along to further enhance the visualisation.
}
\examples{
\dontrun{
## Generate a dataset
dataset <- generate_dataset(type="s", num_genes=500, num_samples=300, num_groups=4)
expression <- dataset$expression
space <- reduce_dimensionality(expression, correlation_distance, ndim=2)
groups <- dataset$sample_info$group_name
traj <- infer_trajectory(space)
time <- traj$time

gimp <- gene_importances(expression, traj$time, num_permutations = 0, ntree = 10000)
gene_sel <- gimp[1:50,]
expr_sel <- expression[,gene_sel$gene]

## Draw a time series heatmap
draw_trajectory_heatmap(expr_sel, time)

## Also show the progression groupings
draw_trajectory_heatmap(expr_sel, time, progression=groups)

## Group the genes into modules and visualise the modules in a heatmap
modules <- extract_modules(scale_quantile(expr_sel))
draw_trajectory_heatmap(expr_sel, time, progression_group=groups, modules=modules)
}
}
