% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_imputation.R
\name{simulation_imputation}
\alias{simulation_imputation}
\title{Simulate Longitudinal Data with Missingness}
\usage{
simulation_imputation(
  n_subject = 800,
  seed = NULL,
  nonrandeff = FALSE,
  nonresidual = FALSE,
  alligned = FALSE
)
}
\arguments{
\item{n_subject}{Number of subjects in the dataset. Each subject has multiple observations. Default: \code{800}.}

\item{seed}{Random seed for reproducibility. Default: \code{123}.}

\item{nonrandeff}{Logical value indicating whether the random effects are non-normal. Default: \code{FALSE}.}

\item{nonresidual}{Logical value indicating whether the residuals are non-normal. Default: \code{FALSE}.}

\item{alligned}{Logical value indicating whether the covariates should be aligned (\code{TRUE})
or shuffled (\code{FALSE}). Default: \code{FALSE}. If it is shuffled, we will return covariate order as X1, X2, X3, X4, X5, X6, X9, X8, X7. If it is alligned, we will return covariate order as X1, X2, X3, X4, X5, X6, X7, X8, X9.}
}
\value{
A list containing:
\describe{
\item{\code{X_mis}}{Matrix of missing covariates.}
\item{\code{Y_mis}}{Vector of missing outcomes.}
\item{\code{Z}}{Matrix of complete random predictors.}
\item{\code{subject_id}}{Vector of subject IDs.}
\item{\code{time}}{Time points for each observation.}
\item{\code{X_O}}{Matrix of original complete covariates (for evaluation).}
\item{\code{Y_O}}{Vector of original complete outcomes (for evaluation).}
}
}
\description{
Generates a dataset with longitudinal data containing missing covariates and outcomes.
The function allows customization of random effects, residuals, and the alignment of covariates to simulate
data under different conditions.
}
\details{
This function creates longitudinal data for multiple subjects, each observed across 6
time points. Non-normal or normal random effects and residual conditions can be specified. Missing values are introduced based MAR assumption.
The alignment of covariates can be customized to test different imputation scenarios.
}
\examples{
simulated_data <- simulation_imputation(
  n_subject = 800,
  seed = 123,
  nonrandeff = TRUE,
  nonresidual = TRUE,
  alligned = FALSE
)
}
\seealso{
\code{\link[stats]{Normal}}, \code{\link[stats]{Uniform}}, \code{\link[stats]{Binomial}}, \code{\link[stats]{Chisquare}}, \code{\link[stats]{GammaDist}}
\code{\link[mvtnorm]{Mvnorm}}
\code{\link[sn]{dmst}}
\code{\link[dplyr]{reexports}}, \code{\link[dplyr]{mutate}}, \code{\link[dplyr]{select}}
\code{\link[tidyr]{pivot_wider}}, \code{\link[tidyr]{pivot_longer}}, \code{\link[tidyr]{reexports}}, \code{\link[tidyr]{separate}}
\code{\link[arm]{invlogit}}
}
