% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMTrees_prediction.R
\name{BMTrees_prediction}
\alias{BMTrees_prediction}
\title{Bayesian Trees Mixed-Effects Models for Predicting Longitudinal Outcomes}
\usage{
BMTrees_prediction(
  X_train,
  Y_train,
  Z_train,
  subject_id_train,
  X_test,
  Z_test,
  subject_id_test,
  model = c("BMTrees", "BMTrees_R", "BMTrees_RE", "mixedBART"),
  binary = FALSE,
  nburn = 3000L,
  npost = 4000L,
  skip = 1L,
  verbose = TRUE,
  seed = NULL,
  tol = 1e-20,
  resample = 5,
  ntrees = 200,
  pi_CDP = 0.99
)
}
\arguments{
\item{X_train}{A matrix of covariates in the training set.}

\item{Y_train}{A numeric or logical vector of outcomes in the training set.}

\item{Z_train}{A matrix of random predictors in the training set.}

\item{subject_id_train}{A character vector of subject IDs in the training set.}

\item{X_test}{A matrix of covariates in the testing set.}

\item{Z_test}{A matrix of random predictors in the testing set.}

\item{subject_id_test}{A character vector of subject IDs in the testing set.}

\item{model}{A character string specifying the predictive model. Options are \code{"BMTrees"},
\code{"BMTrees_R"}, \code{"BMTrees_RE"}, and \code{"mixedBART"}. Default: \code{"BMTrees"}.}

\item{binary}{Logical. Indicates whether the outcome is binary (\code{TRUE}) or continuous (\code{FALSE}).
Default: \code{FALSE}.}

\item{nburn}{An integer specifying the number of burn-in iterations for Gibbs sampler.
Default: \code{3000L}.}

\item{npost}{An integer specifying the number of posterior samples to collect. Default: \code{4000L}.}

\item{skip}{An integer indicating the thinning interval for MCMC samples. Default: \code{1L}.}

\item{verbose}{Logical. If \code{TRUE}, displays MCMC progress. If \code{FALSE}, shows a progress bar.
Default: \code{TRUE}.}

\item{seed}{An optional integer for setting the random seed to ensure reproducibility. Default: \code{NULL}.}

\item{tol}{A numeric tolerance value to prevent numerical overflow and underflow in the model. Default: \code{1e-20}.}

\item{resample}{An integer specifying the number of resampling steps for the CDP prior. Default: \code{5}. This parameter is only valid for \code{"BMTrees"} and \code{"BMTrees_R"}.}

\item{ntrees}{An integer specifying the number of trees in BART. Default: \code{200}.}

\item{pi_CDP}{A value between 0 and 1 for calculating the empirical prior in the CDP prior. Default: \code{0.99}.}
}
\value{
A list containing posterior samples and predictions:
\describe{
\item{post_tree_train}{Posterior samples of the fixed-effects from BART on training data.}
\item{post_Sigma}{Posterior samples of covariance matrices in random effects.}
\item{post_lambda_F}{Posterior samples of lambda parameter in CDP normal mixture on random errors.}
\item{post_lambda_G}{Posterior samples of lambda parameter in CDP normal mixture on random-effects.}
\item{post_B}{Posterior samples of the coefficients in random effects.}
\item{post_random_effect_train}{Posterior samples of random effects for training data.}
\item{post_sigma}{Posterior samples of error deviation.}
\item{post_expectation_y_train}{Posterior expectations of training data outcomes, equal to fixed-effects + random effects.}
\item{post_expectation_y_test}{Posterior expectations of testing data outcomes, equal to fixed-effects + random effects.}
\item{post_predictive_y_train}{Posterior predictive distributions for training outcomes, equal to fixed-effects + random effects + predictive residual.}
\item{post_predictive_y_test}{Posterior predictive distributions for testing outcomes, equal to fixed-effects + random effects + predictive residual.}
\item{post_eta}{Posterior samples of location parameters in CDP normal mixture on random errors.}
\item{post_mu}{Posterior samples of location parameters in CDP normal mixture on random effects.}
}
}
\description{
Provides predictions for outcomes in longitudinal data using Bayesian Trees
Mixed-Effects Models (BMTrees) and its semiparametric variants. The function predicts values for test
data while accounting for random effects, complex relationships, and potential model misspecification.
}
\note{
This function utilizes modified C++ code originally derived from the
BART3 package (Bayesian Additive Regression Trees). The original package
was developed by Rodney Sparapani and is licensed
under GPL-2. Modifications were made by Jungang Zou, 2024.
}
\examples{
\donttest{
data = simulation_prediction(n_subject = 100, seed = 1234, nonlinear = TRUE, 
nonrandeff = TRUE, nonresidual = TRUE) 

# To make it faster to compile and check, we only run 30 iterations for burn-in 
# and 40 for posterior sampling phases.
# Please increase to 3000 and 4000 iterations, respectively, when running the model.
model = BMTrees_prediction(data$X_train, data$Y_train, data$Z_train, 
data$subject_id_train, data$X_test, data$Z_test, data$subject_id_test, model = "BMTrees", 
binary = FALSE, nburn = 30L, npost = 40L, skip = 1L, verbose = TRUE, seed = 1234)
model$post_predictive_y_test
model$post_sigma
}
}
\references{
For more information about the original BART3 package, see:
https://github.com/rsparapa/bnptools/tree/master/BART3
}
