% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{vmeasure}
\alias{vmeasure}
\title{V-measure}
\usage{
vmeasure(z, truez, beta = 1)
}
\arguments{
\item{z}{input vector}

\item{truez}{reference vector}

\item{beta}{parameter \code{beta=1} gives equal weight to homogeneity and completeness}
}
\value{
v-measure of z against \code{truez}
}
\description{
Calculate the V-measure of two clusterings
}
\details{
An information based measure of similarity between two clusterings
}
\examples{
vmeasure(c(1,1,2,2,3,3), c(2,2,1,1,3,3)) ## 1 - doesn't care for labels
vmeasure(c(1,1,2,2,3,3), c(1,1,2,2,2,2)) ## 0.7333
vmeasure(c(1,1,2,2,3,3), c(1,1,2,2,3,4)) ## 0.904
}
\seealso{
Rosenberg, A., & Hirschberg, J. (2007, June). V-measure: A conditional entropy-based external cluster evaluation measure. In Proceedings of the 2007 joint conference on empirical methods in natural language processing and computational natural language learning (EMNLP-CoNLL) (pp. 410-420).
}
