% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_saver.R
\name{sample.saver}
\alias{sample.saver}
\title{Samples from SAVER}
\usage{
sample.saver(x, rep = 1, efficiency.known = FALSE, seed = NULL)
}
\arguments{
\item{x}{A \code{saver} object.}

\item{rep}{Number of sampled datasets. Default is 1.}

\item{efficiency.known}{Whether the efficiency is known. Default is
\code{FALSE}.}

\item{seed}{seed used in \code{set.seed}.}
}
\value{
A matrix of expression values sampled from SAVER posterior. If
\code{rep} > 1, a list of matrices is returned
}
\description{
Samples from the posterior distribution output by SAVER.
}
\details{
The SAVER method outputs a posterior distribution, which we can sample from
for downstream analysis. The posterior distribution accounts for uncertainty
in the SAVER estimation procedure. If the efficiency is known,
negative binomial sampling is performed; otherwise, gamma sampling is
performed.
}
\examples{
data("linnarsson_saver")

samp1 <- sample.saver(linnarsson_saver, seed = 50)


}
