### $Id: WaferTypes.R,v 1.1 2000/02/09 18:36:49 bates Exp $
### A complex split plot design in semiconductor wafer fabrication.
### There are crossed factors of Type and Temperatures within Group.
### Data set 5.8 from "SAS System for Mixed Models"
"WaferTypes" <-
  structure(list(
  Group = structure(factor(c(1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4), levels=1:4), class = "factor",
    .Label = c("1", "2", "3", "4")),
Temperature = structure(ordered(c(1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3), levels=1:3),
  class = c("ordered", "factor"),
  .Label = c("900", "1000", "1100")),
Type = structure(factor(c(1, 
  1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 
  2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 
  1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 
  2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2), levels=1:2),
  .Label = c("A", "B"), class = "factor"),
Wafer = c(1, 1, 1, 2, 2, 2, 1, 1, 1, 
  2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 
  1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 
  2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 
  1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 
  2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 
  1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 
  2, 2, 2, 1, 1, 1, 2, 2, 2),
Site = c(1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 
  3, 1, 2, 3, 1, 2, 3, 1, 2, 3),
delta = c(291, 295, 294, 318, 
  315, 315, 349, 348, 345, 332, 334, 331, 319, 315, 321, 290, 289, 
  292, 358, 357, 362, 365, 367, 367, 264, 266, 268, 276, 280, 278, 
  352, 353, 350, 330, 330, 334, 306, 302, 305, 342, 341, 336, 342, 
  341, 340, 366, 363, 361, 299, 296, 297, 329, 330, 332, 348, 346, 
  346, 350, 346, 347, 285, 292, 289, 306, 303, 304, 357, 360, 359, 
  361, 361, 360, 318, 323, 323, 307, 308, 308, 372, 371, 370, 348, 
  349, 352, 264, 265, 265, 274, 268, 275, 332, 337, 335, 322, 326, 
  321, 273, 275, 276, 276, 273, 273, 333, 332, 332, 349, 350, 352, 
  295, 297, 296, 326, 326, 328, 322, 325, 327, 335, 332, 334, 258, 
  260, 260, 280, 276, 278, 319, 322, 317, 311, 313, 313, 282, 282, 
  279, 271, 271, 270, 335, 339, 338, 304, 303, 303),
Thick = c(1919, 
  1919, 1919, 2113, 2113, 2113, 1965, 1965, 1965, 1829, 1829, 1829, 
  2098, 2098, 2098, 1823, 1823, 1823, 2059, 2059, 2059, 2145, 2145, 
  2145, 1846, 1846, 1846, 2028, 2028, 2028, 2086, 2086, 2086, 1899, 
  1899, 1899, 1841, 1841, 1841, 2170, 2170, 2170, 1981, 1981, 1981, 
  2190, 2190, 2190, 1915, 1915, 1915, 2161, 2161, 2161, 2072, 2072, 
  2072, 2082, 2082, 2082, 1854, 1854, 1854, 2046, 2046, 2046, 2062, 
  2062, 2062, 2055, 2055, 2055, 2019, 2019, 2019, 1872, 1872, 1872, 
  2182, 2182, 2182, 1973, 1973, 1973, 1828, 1828, 1828, 1827, 1827, 
  1827, 2109, 2109, 2109, 2003, 2003, 2003, 1925, 1925, 1925, 1942, 
  1942, 1942, 1893, 1893, 1893, 2170, 2170, 2170, 1862, 1862, 1862, 
  2149, 2149, 2149, 1888, 1888, 1888, 1998, 1998, 1998, 1815, 1815, 
  1815, 1981, 1981, 1981, 2012, 2012, 2012, 1892, 1892, 1892, 2083, 
  2083, 2083, 2036, 2036, 2036, 2174, 2174, 2174, 1802, 1802, 1802),
uWafer = structure(ordered(c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 
  4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 
  11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 
  16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 
  21, 22, 22, 22, 23, 23, 23, 24, 24, 24, 25, 25, 25, 26, 26, 26, 
  27, 27, 27, 28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 
  32, 32, 33, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 
  37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41, 41, 41, 42, 42, 42, 
  43, 43, 43, 44, 44, 44, 45, 45, 45, 46, 46, 46, 47, 47, 47, 48, 
  48, 48), levels=1:48),
  class = c("ordered", "factor"),
  .Label = c("1/900/A/1", 
    "1/900/A/2", "1/900/B/1", "1/900/B/2", "1/1000/A/1", "1/1000/A/2", 
    "1/1000/B/1", "1/1000/B/2", "1/1100/A/1", "1/1100/A/2", "1/1100/B/1", 
    "1/1100/B/2", "2/900/A/1", "2/900/A/2", "2/900/B/1", "2/900/B/2", 
    "2/1000/A/1", "2/1000/A/2", "2/1000/B/1", "2/1000/B/2", "2/1100/A/1", 
    "2/1100/A/2", "2/1100/B/1", "2/1100/B/2", "3/900/A/1", "3/900/A/2", 
    "3/900/B/1", "3/900/B/2", "3/1000/A/1", "3/1000/A/2", "3/1000/B/1", 
    "3/1000/B/2", "3/1100/A/1", "3/1100/A/2", "3/1100/B/1", "3/1100/B/2", 
    "4/900/A/1", "4/900/A/2", "4/900/B/1", "4/900/B/2", "4/1000/A/1", 
    "4/1000/A/2", "4/1000/B/1", "4/1000/B/2", "4/1100/A/1", "4/1100/A/2", 
    "4/1100/B/1", "4/1100/B/2"))),
class = c("nffGroupedData", "nfGroupedData", "groupedData", "data.frame"),
row.names = 1:144,
formula = delta ~ 1 | uWafer,
labels = list(y = "Rate of deposition of polysilicon"),
FUN = function (x) mean(x, na.rm = TRUE),
order.groups = TRUE)
