% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SADISA_loglik.R
\name{SADISA_loglik}
\alias{SADISA_loglik}
\title{Computes loglikelihood for requested model}
\usage{
SADISA_loglik(abund, pars, model, mult = "single")
}
\arguments{
\item{abund}{abundance vector or a list of abundance vectors.
When a list is provided and mult = 'mg' (the default), it is assumed that the different vectors
apply to different guilds. When mult = 'ms' then the different vectors apply to multiple samples
from the same metacommunity. In this case the vectors should have equal lengths and may contain
zeros because there may be species that occur in multiple samples and species that do not occur
in some of the samples. When mult= 'both', abund should be a list of lists, each list representing
multiple guilds within a sample}

\item{pars}{a vector of model parameters or a list of vectors of model parameters.
When a list is provided and mult = 'mg' (the default), it is assumed that the different vectors
apply to different guilds. Otherwise, it is assumed that they apply to multiple samples.}

\item{model}{the chosen combination of metacommunity model and local community model
as a vector, e.g. c('pm','dl') for a model with point mutation in the metacommunity and
dispersal limitation.
The choices for the metacommunity model are: 'pm' (point mutation), 'rf' (random fission),
'pr' (protracted speciation), 'dd' (density-dependence).
The choices for the local community model are: 'dl' (dispersal limitation), 'dd' (density-dependence).}

\item{mult}{When set to 'single' (the default), the loglikelihood for a single sample is computed
When set to 'mg' the loglikelihood for multiple guilds is computed.
When set to 'ms' the loglikelihood for multiple samples from the same metacommunity is computed.
When set to 'both' the loglikelihood for multiple guilds within multiple samples is computed.}
}
\value{
loglikelihood
}
\description{
Computes loglikelihood for requested model using independent-species approach
}
\details{
Not all combinations of metacommunity model and local community model have been implemented yet.
because this requires checking for numerical stability of the integration. The currently available model combinations are, for a single sample, c('pm','dl'), c('pm','rf'), c('dd','dl'),
c('pr','dl'), c('pm','dd'), and for multiple samples, c('pm','dl').
}
\examples{
data(datasets);
abund_bci <- datasets$dset1.abunvec[[1]];
data(fitresults);
data.paropt <- fitresults$fit1a.parsopt[[1]];
result <- SADISA_loglik(abund = abund_bci,pars = data.paropt,model = c('pm','dl'));
cat('The difference between result and the value in fitresults.RData is:',
result - fitresults$fit1a.llikopt[[1]]);
}
\references{
Haegeman, B. & R.S. Etienne (2017). A general sampling formula for community structure data. Methods in Ecology & Evolution 8: 1506-1519. doi: 10.1111/2041-210X.12807
}
\keyword{model}
\keyword{species-abundance-distribution}
