
rxodeTest(
  {
    require(RxODE)
    context("Example 6")
    require(digest)

    inf.dat <- structure(list(
      time = structure(c(
        0, 0.0417, 0.0833, 0.125, 0.1667,
        0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417,
        0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167,
        0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917,
        1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667,
        1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417,
        2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167,
        2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917,
        2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667,
        3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417,
        3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167,
        3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917,
        4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667,
        4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417,
        5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167,
        5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917,
        5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667,
        6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417,
        6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167,
        6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917,
        7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667,
        7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417,
        8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167,
        8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917,
        8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667,
        9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417,
        9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167,
        9.9583, 10
      ), class = "units", units = structure(list(
        numerator = "d",
        denominator = character(0)
      ), class = "symbolic_units")),
      intestine = c(
        0, 0.0737, 0.0574, 0.0447, 0.0348, 0.0271,
        0.0211, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04, 0.0739, 0.0576, 0.0448, 0.0349, 0.0272,
        0.0212, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0037,
        0.0029, 0.0022, 0.0017, 0.0014, 0.0011, 8e-04, 6e-04, 5e-04,
        4e-04, 3e-04, 2e-04
      ), blood = c(
        0, 0.0095, 0.0254, 0.0373,
        0.0461, 0.0526, 0.0572, 0.0604, 0.0625, 0.0638, 0.0644, 0.0645,
        0.0642, 0.0637, 0.0629, 0.062, 0.0609, 0.0598, 0.0586, 0.0574,
        0.0562, 0.0549, 0.0537, 0.0524, 0.0512, 0.0595, 0.0742, 0.0849,
        0.0926, 0.0979, 0.1015, 0.1036, 0.1046, 0.1048, 0.1044, 0.1036,
        0.1023, 0.1008, 0.0991, 0.0973, 0.0954, 0.0934, 0.0914, 0.0894,
        0.0874, 0.0853, 0.0834, 0.0814, 0.0794, 0.087, 0.101, 0.1111,
        0.1182, 0.1229, 0.1258, 0.1273, 0.1277, 0.1274, 0.1264, 0.125,
        0.1232, 0.1212, 0.119, 0.1167, 0.1143, 0.1119, 0.1094, 0.107,
        0.1045, 0.1021, 0.0996, 0.0973, 0.0949, 0.1022, 0.1158, 0.1255,
        0.1322, 0.1365, 0.1391, 0.1403, 0.1404, 0.1398, 0.1385, 0.1368,
        0.1347, 0.1324, 0.13, 0.1274, 0.1247, 0.122, 0.1193, 0.1166,
        0.1139, 0.1112, 0.1086, 0.106, 0.1034, 0.1105, 0.1239, 0.1334,
        0.1399, 0.144, 0.1464, 0.1474, 0.1474, 0.1466, 0.1451, 0.1432,
        0.141, 0.1386, 0.136, 0.1332, 0.1304, 0.1276, 0.1247, 0.1219,
        0.1191, 0.1163, 0.1135, 0.1108, 0.1081, 0.115, 0.1283, 0.1377,
        0.1441, 0.1482, 0.1504, 0.1514, 0.1512, 0.1503, 0.1488, 0.1468,
        0.1445, 0.142, 0.1393, 0.1364, 0.1336, 0.1306, 0.1277, 0.1248,
        0.1219, 0.119, 0.1162, 0.1134, 0.1107, 0.1175, 0.1307, 0.1401,
        0.1464, 0.1504, 0.1526, 0.1535, 0.1533, 0.1523, 0.1508, 0.1487,
        0.1464, 0.1438, 0.1411, 0.1382, 0.1353, 0.1323, 0.1293, 0.1264,
        0.1234, 0.1205, 0.1177, 0.1148, 0.1121, 0.1189, 0.1321, 0.1414,
        0.1477, 0.1517, 0.1539, 0.1547, 0.1545, 0.1535, 0.1519, 0.1498,
        0.1474, 0.1448, 0.142, 0.1392, 0.1362, 0.1332, 0.1302, 0.1273,
        0.1243, 0.1214, 0.1185, 0.1156, 0.1128, 0.1196, 0.1328, 0.1421,
        0.1484, 0.1523, 0.1545, 0.1553, 0.1551, 0.1541, 0.1525, 0.1504,
        0.148, 0.1454, 0.1426, 0.1397, 0.1367, 0.1337, 0.1307, 0.1277,
        0.1248, 0.1218, 0.1189, 0.1161, 0.1133, 0.12, 0.1332, 0.1425,
        0.1488, 0.1527, 0.1549, 0.1557, 0.1554, 0.1544, 0.1528, 0.1507,
        0.1483, 0.1457, 0.1429, 0.14, 0.137, 0.134, 0.131, 0.128,
        0.125, 0.1221, 0.1192, 0.1163, 0.1135
      )
    ), row.names = c(
      NA,
      -241L
    ), class = "data.frame")

    inf.dat2 <- structure(list(
      time = structure(c(
        0, 0.0417, 0.0833, 0.125, 0.1667,
        0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417,
        0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167,
        0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917,
        1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667,
        1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417,
        2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167,
        2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917,
        2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667,
        3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417,
        3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167,
        3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917,
        4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667,
        4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417,
        5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167,
        5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917,
        5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667,
        6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417,
        6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167,
        6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917,
        7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667,
        7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417,
        8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167,
        8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917,
        8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667,
        9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417,
        9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167,
        9.9583, 10
      ), class = "units", units = structure(list(
        numerator = "d",
        denominator = character(0)
      ), class = "symbolic_units")),
      intestine = c(
        0, 0.0737, 0.0574, 0.0447, 0.0348, 0.0271,
        0.0211, 0.0165, 0.0128, 0.01, 0.0078, 0.0061, 0.0047, 0.0774,
        0.0603, 0.0469, 0.0366, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105,
        0.0082, 0.0064, 0.0049, 0.0776, 0.0604, 0.0471, 0.0366, 0.0285,
        0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776,
        0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105,
        0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285,
        0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776,
        0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105,
        0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285,
        0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776,
        0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105,
        0.0082, 0.0064, 0.005, 0.0776, 0.0604, 0.0471, 0.0367, 0.0285,
        0.0222, 0.0173, 0.0135, 0.0105, 0.0082, 0.0064, 0.005, 0.0776,
        0.0604, 0.0471, 0.0367, 0.0285, 0.0222, 0.0173, 0.0135, 0.0105,
        0.0082, 0.0064, 0.005, 0.0039, 0.003, 0.0023, 0.0018, 0.0014,
        0.0011, 9e-04, 7e-04, 5e-04, 4e-04, 3e-04, 2e-04, 2e-04,
        1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
      ), blood = c(
        0,
        0.0095, 0.0254, 0.0373, 0.0461, 0.0526, 0.0572, 0.0604, 0.0625,
        0.0638, 0.0644, 0.0645, 0.0642, 0.0732, 0.0883, 0.0993, 0.1071,
        0.1124, 0.1158, 0.1178, 0.1187, 0.1187, 0.118, 0.1169, 0.1154,
        0.1232, 0.1371, 0.1469, 0.1535, 0.1577, 0.1601, 0.161, 0.1608,
        0.1598, 0.1581, 0.156, 0.1535, 0.1603, 0.1733, 0.1822, 0.188,
        0.1914, 0.1929, 0.193, 0.192, 0.1902, 0.1878, 0.1849, 0.1818,
        0.1879, 0.2002, 0.2084, 0.2136, 0.2163, 0.2172, 0.2167, 0.2151,
        0.2127, 0.2098, 0.2064, 0.2027, 0.2083, 0.2201, 0.2278, 0.2325,
        0.2348, 0.2352, 0.2342, 0.2322, 0.2294, 0.2261, 0.2223, 0.2182,
        0.2234, 0.2348, 0.2422, 0.2465, 0.2484, 0.2485, 0.2473, 0.2449,
        0.2418, 0.2381, 0.2341, 0.2297, 0.2346, 0.2457, 0.2529, 0.2569,
        0.2586, 0.2584, 0.2569, 0.2543, 0.251, 0.2471, 0.2428, 0.2382,
        0.2429, 0.2538, 0.2608, 0.2646, 0.2661, 0.2657, 0.264, 0.2613,
        0.2578, 0.2537, 0.2492, 0.2445, 0.249, 0.2598, 0.2666, 0.2703,
        0.2716, 0.2712, 0.2693, 0.2664, 0.2628, 0.2586, 0.254, 0.2491,
        0.2441, 0.2389, 0.2336, 0.2284, 0.2231, 0.2179, 0.2128, 0.2077,
        0.2028, 0.1979, 0.1931, 0.1884, 0.1838, 0.1793, 0.1749, 0.1706,
        0.1664, 0.1623, 0.1583, 0.1544, 0.1506, 0.1469, 0.1433, 0.1397,
        0.1363, 0.1329, 0.1297, 0.1265, 0.1233, 0.1203, 0.1173, 0.1144,
        0.1116, 0.1088, 0.1062, 0.1035, 0.101, 0.0985, 0.0961, 0.0937,
        0.0914, 0.0891, 0.0869, 0.0848, 0.0827, 0.0806, 0.0786, 0.0767,
        0.0748, 0.073, 0.0712, 0.0694, 0.0677, 0.066, 0.0644, 0.0628,
        0.0612, 0.0597, 0.0583, 0.0568, 0.0554, 0.054, 0.0527, 0.0514,
        0.0501, 0.0489, 0.0477, 0.0465, 0.0454, 0.0443, 0.0432, 0.0421,
        0.0411, 0.04, 0.0391, 0.0381, 0.0371, 0.0362, 0.0353, 0.0345,
        0.0336, 0.0328, 0.032, 0.0312, 0.0304, 0.0297, 0.0289, 0.0282,
        0.0275, 0.0268, 0.0262, 0.0255, 0.0249, 0.0243, 0.0237, 0.0231,
        0.0225, 0.022, 0.0214, 0.0209, 0.0204, 0.0199, 0.0194, 0.0189,
        0.0184, 0.018, 0.0175, 0.0171, 0.0167, 0.0163, 0.0159, 0.0155,
        0.0151, 0.0147, 0.0144, 0.014, 0.0137, 0.0133, 0.013, 0.0127
      )
    ), row.names = c(NA, -241L), class = "data.frame")

    dat3 <- structure(list(
      time = structure(c(
        0, 0.0417, 0.0833, 0.125, 0.1667,
        0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417,
        0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167,
        0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917,
        1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667,
        1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417,
        2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167,
        2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917,
        2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667,
        3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417,
        3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167,
        3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917,
        4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667,
        4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417,
        5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167,
        5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917,
        5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667,
        6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417,
        6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167,
        6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917,
        7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667,
        7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417,
        8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167,
        8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917,
        8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667,
        9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417,
        9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167,
        9.9583, 10
      ), class = "units", units = structure(list(
        numerator = "d",
        denominator = character(0)
      ), class = "symbolic_units")),
      blood = c(
        40, 39.0124, 38.0491, 37.1097, 36.1935, 35.2999,
        34.4283, 33.5783, 32.7492, 31.9406, 31.152, 30.3829, 29.6327,
        28.9011, 28.1875, 27.4916, 26.8128, 26.1508, 25.5051, 24.8754,
        24.2612, 23.6622, 23.078, 22.5082, 61.9525, 60.4228, 58.9309,
        57.476, 56.0569, 54.6728, 53.3229, 52.0064, 50.7224, 49.47,
        48.2486, 47.0573, 45.8955, 44.7623, 43.6571, 42.5792, 41.528,
        40.5026, 39.5026, 38.5273, 37.576, 36.6483, 35.7434, 34.8609,
        74.0002, 72.1731, 70.3911, 68.6532, 66.9582, 65.305, 63.6926,
        62.12, 60.5862, 59.0904, 57.6314, 56.2085, 54.8207, 53.4672,
        52.1471, 50.8596, 49.6038, 48.3791, 47.1846, 46.0196, 44.8834,
        43.7752, 42.6944, 41.6403, 80.6122, 78.6219, 76.6806, 74.7874,
        72.9409, 71.14, 69.3836, 67.6705, 65.9997, 64.3701, 62.7808,
        61.2308, 59.719, 58.2445, 56.8064, 55.4039, 54.036, 52.7018,
        51.4006, 50.1315, 48.8938, 47.6866, 46.5092, 45.3609, 84.2409,
        82.161, 80.1324, 78.154, 76.2243, 74.3424, 72.5068, 70.7166,
        68.9706, 67.2677, 65.6069, 63.9871, 62.4072, 60.8664, 59.3636,
        57.8979, 56.4684, 55.0742, 53.7144, 52.3882, 51.0947, 49.8332,
        48.6028, 47.4028, 86.2324, 84.1033, 82.0268, 80.0016, 78.0263,
        76.0998, 74.2209, 72.3884, 70.6011, 68.858, 67.1579, 65.4997,
        63.8825, 62.3053, 60.767, 59.2666, 57.8033, 56.3762, 54.9842,
        53.6267, 52.3026, 51.0113, 49.7518, 48.5234, 87.3254, 85.1693,
        83.0664, 81.0156, 79.0153, 77.0644, 75.1617, 73.3059, 71.496,
        69.7307, 68.0091, 66.3299, 64.6922, 63.095, 61.5372, 60.0178,
        58.536, 57.0907, 55.6811, 54.3063, 52.9655, 51.6578, 50.3824,
        49.1384, 87.9252, 85.7543, 83.637, 81.572, 79.558, 77.5937,
        75.6779, 73.8094, 71.9871, 70.2097, 68.4762, 66.7855, 65.1366,
        63.5284, 61.9598, 60.4301, 58.938, 57.4828, 56.0636, 54.6794,
        53.3293, 52.0126, 50.7284, 49.4759, 88.2544, 86.0754, 83.9502,
        81.8774, 79.8559, 77.8842, 75.9613, 74.0858, 72.2566, 70.4726,
        68.7326, 67.0356, 65.3805, 63.7662, 62.1918, 60.6563, 59.1587,
        57.6981, 56.2735, 54.8841, 53.529, 52.2074, 50.9184, 49.6612,
        88.435, 86.2516, 84.122, 82.0451, 80.0194, 78.0437, 76.1168,
        74.2374, 72.4045, 70.6168, 68.8733, 67.1728, 65.5143, 63.8968,
        62.3191, 60.7805, 59.2798, 57.8162, 56.3887, 54.9965, 53.6386,
        52.3142, 51.0226, 49.7628, 88.5342
      )
    ), row.names = c(NA, -241L), class = "data.frame")

    dat4 <- structure(list(
      time = structure(c(
        0, 0.0417, 0.0833, 0.125, 0.1667,
        0.2083, 0.25, 0.2917, 0.3333, 0.375, 0.4167, 0.4583, 0.5, 0.5417,
        0.5833, 0.625, 0.6667, 0.7083, 0.75, 0.7917, 0.8333, 0.875, 0.9167,
        0.9583, 1, 1.0417, 1.0833, 1.125, 1.1667, 1.2083, 1.25, 1.2917,
        1.3333, 1.375, 1.4167, 1.4583, 1.5, 1.5417, 1.5833, 1.625, 1.6667,
        1.7083, 1.75, 1.7917, 1.8333, 1.875, 1.9167, 1.9583, 2, 2.0417,
        2.0833, 2.125, 2.1667, 2.2083, 2.25, 2.2917, 2.3333, 2.375, 2.4167,
        2.4583, 2.5, 2.5417, 2.5833, 2.625, 2.6667, 2.7083, 2.75, 2.7917,
        2.8333, 2.875, 2.9167, 2.9583, 3, 3.0417, 3.0833, 3.125, 3.1667,
        3.2083, 3.25, 3.2917, 3.3333, 3.375, 3.4167, 3.4583, 3.5, 3.5417,
        3.5833, 3.625, 3.6667, 3.7083, 3.75, 3.7917, 3.8333, 3.875, 3.9167,
        3.9583, 4, 4.0417, 4.0833, 4.125, 4.1667, 4.2083, 4.25, 4.2917,
        4.3333, 4.375, 4.4167, 4.4583, 4.5, 4.5417, 4.5833, 4.625, 4.6667,
        4.7083, 4.75, 4.7917, 4.8333, 4.875, 4.9167, 4.9583, 5, 5.0417,
        5.0833, 5.125, 5.1667, 5.2083, 5.25, 5.2917, 5.3333, 5.375, 5.4167,
        5.4583, 5.5, 5.5417, 5.5833, 5.625, 5.6667, 5.7083, 5.75, 5.7917,
        5.8333, 5.875, 5.9167, 5.9583, 6, 6.0417, 6.0833, 6.125, 6.1667,
        6.2083, 6.25, 6.2917, 6.3333, 6.375, 6.4167, 6.4583, 6.5, 6.5417,
        6.5833, 6.625, 6.6667, 6.7083, 6.75, 6.7917, 6.8333, 6.875, 6.9167,
        6.9583, 7, 7.0417, 7.0833, 7.125, 7.1667, 7.2083, 7.25, 7.2917,
        7.3333, 7.375, 7.4167, 7.4583, 7.5, 7.5417, 7.5833, 7.625, 7.6667,
        7.7083, 7.75, 7.7917, 7.8333, 7.875, 7.9167, 7.9583, 8, 8.0417,
        8.0833, 8.125, 8.1667, 8.2083, 8.25, 8.2917, 8.3333, 8.375, 8.4167,
        8.4583, 8.5, 8.5417, 8.5833, 8.625, 8.6667, 8.7083, 8.75, 8.7917,
        8.8333, 8.875, 8.9167, 8.9583, 9, 9.0417, 9.0833, 9.125, 9.1667,
        9.2083, 9.25, 9.2917, 9.3333, 9.375, 9.4167, 9.4583, 9.5, 9.5417,
        9.5833, 9.625, 9.6667, 9.7083, 9.75, 9.7917, 9.8333, 9.875, 9.9167,
        9.9583, 10
      ), class = "units", units = structure(list(
        numerator = "d",
        denominator = character(0)
      ), class = "symbolic_units")),
      blood = c(
        40, 39.0124, 38.0491, 37.1097, 36.1935, 35.2999,
        34.4283, 33.5783, 32.7492, 31.9406, 31.152, 30.3829, 69.6327,
        67.9134, 66.2366, 64.6013, 63.0062, 61.4506, 59.9334, 58.4536,
        57.0104, 55.6028, 54.23, 52.891, 91.5851, 89.3239, 87.1184,
        84.9675, 82.8696, 80.8236, 78.828, 76.8818, 74.9835, 73.1322,
        71.3266, 69.5655, 107.8479, 105.1851, 102.588, 100.0552,
        97.5848, 95.1754, 92.8255, 90.5337, 88.2984, 86.1183, 83.992,
        81.9183, 119.8957, 116.9355, 114.0482, 111.2324, 108.4861,
        105.8076, 103.1952, 100.6473, 98.1623, 95.7386, 93.3748,
        91.0694, 128.8209, 125.6403, 122.5382, 119.5128, 116.562,
        113.684, 110.8772, 108.1396, 105.4696, 102.8656, 100.3258,
        97.8488, 135.4329, 132.0891, 128.8277, 125.647, 122.5447,
        119.5191, 116.5682, 113.6901, 110.8831, 108.1454, 105.4752,
        102.871, 140.3311, 136.8664, 133.4871, 130.1913, 126.9769,
        123.8418, 120.7842, 117.802, 114.8934, 112.0567, 109.29,
        106.5916, 143.9599, 140.4056, 136.9388, 133.5579, 130.2603,
        127.0442, 123.9074, 120.8482, 117.8644, 114.9543, 112.1161,
        109.3479, 146.6481, 143.0274, 139.496, 136.0519, 132.6927,
        129.4165, 126.2212, 123.1048, 120.0654, 117.1009, 114.2097,
        111.3898, 148.6396, 144.9698, 141.3904, 137.8995, 134.4947,
        131.174, 127.9353, 124.7766, 121.6959, 118.6912, 115.7607,
        112.9025, 150.115, 146.4087, 142.7937, 139.2682, 135.8297,
        132.476, 129.2052, 126.0151, 122.9038, 119.8693, 116.9097,
        114.0232, 151.2079, 147.4747, 143.8334, 140.2822, 136.8186,
        133.4406, 130.1459, 126.9326, 123.7986, 120.742, 117.7609,
        114.8534, 152.0176, 148.2644, 144.6036, 141.0334, 137.5513,
        134.1551, 130.8428, 127.6123, 124.4615, 121.3886, 118.3915,
        115.4684, 152.6174, 148.8494, 145.1742, 141.5899, 138.094,
        134.6845, 131.3591, 128.1158, 124.9526, 121.8675, 118.8586,
        115.924, 153.0618, 149.2828, 145.5969, 142.0021, 138.4961,
        135.0766, 131.7416, 128.4888, 125.3164, 122.2224, 119.2047,
        116.2615, 153.391, 149.6038, 145.91, 142.3075, 138.794, 135.3671,
        132.0249, 128.7652, 125.586, 122.4852, 119.4611, 116.5116,
        153.6349, 149.8417, 146.142, 142.5338, 139.0146, 135.5823,
        132.2348, 128.9699, 125.7856, 122.68, 119.651, 116.6968,
        153.8156, 150.0179, 146.3139, 142.7014, 139.1781, 135.7418,
        132.3903, 129.1216, 125.9336, 122.8242, 119.7917, 116.834,
        153.9494, 150.1484, 146.4412, 142.8256, 139.2992, 135.8599,
        132.5055, 129.2339, 126.0431, 122.9311, 119.8959, 116.9357,
        114.0486
      )
    ), row.names = c(NA, -241L), class = "data.frame")

    ## https://cran.r-project.org/web/packages/diffEq/vignettes/ODEinR.pdf p11

    ## 6.1
    mod <- RxODE("
a = 6
b = 0.6
d/dt(intestine) = -a*intestine
d/dt(blood)     = a*intestine - b*blood
")

    et <- eventTable(time.units = "days")
    et$add.sampling(seq(0, 10, by = 1 / 24))
    et$add.dosing(
      dose = 2 / 24, rate = 2, start.time = 0,
      nbr.doses = 10, dosing.interval = 1
    )

    pk <- solve(mod, et)

    test_that("params are captured correctly", {
      expect_equal(pk$.params.single, c(a = 6, b = 0.6))
    })


    ## plot(pk$time,pk$intestine,type="l")
    ## plot(pk$time,pk$blood,type="l")
    test_that("infusion model works.", {
      expect_equal(round(as.data.frame(pk), 4), inf.dat)
    })

    pk2 <- solve(mod, et, matrix = TRUE)
    test_that("matrix solving works.", {
      expect_equal(as.matrix(pk), pk2)
    })

    ## Change QD dosing to BID dosing.
    et2 <- eventTable(time.units = "days")
    et2$add.sampling(seq(0, 10, by = 1 / 24))
    et2$add.dosing(
      dose = 2 / 24, rate = 2, strt.time = 0,
      nbr.doses = 10, dosing.interval = 0.5
    )

    pk2 <- solve(pk, et2)

    ## plot(pk2$time,pk2$intestine,type="l")
    ## plot(pk2$time,pk2$blood,type="l")

    test_that("bid infusion works.", {
      expect_equal(
        round(as.data.frame(pk2), 4),
        inf.dat2
      )
    })


    ## Bolus 6.2
    mod <- RxODE("
b = 0.6
d/dt(blood) = - b*blood
")

    et <- eventTable(time.units = "days")
    et$add.sampling(seq(0, 10, by = 1 / 24))
    et$add.dosing(start.time = 0, dose = 40, nbr.doses = 20, dosing.interval = 1)

    pk <- solve(mod, et)

    ## plot(pk$time,pk$blood,type="l")

    test_that("bolus model works", {
      expect_equal(round(as.data.frame(pk), 4), dat3)
    })

    et2 <- eventTable(time.units = "days")
    et2$add.sampling(seq(0, 10, by = 1 / 24))
    et2$add.dosing(start.time = 0, dose = 40, nbr.doses = 20, dosing.interval = 0.5)

    pk2 <- rxSolve(pk, et2)

    ## plot(pk2$time,pk2$blood,type="l")

    test_that("bolus model bid works", {
      expect_equal(round(as.data.frame(pk2), 4), dat4)
    })
  },
  silent = TRUE,
  test = "lvl2"
)
