% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rxSimThetaOmega}
\alias{rxSimThetaOmega}
\title{Simulate Parameters from a Theta/Omega specification}
\usage{
rxSimThetaOmega(params = NULL, omega = NULL, omegaDf = NULL,
  omegaIsChol = FALSE, nSub = 1L, thetaMat = NULL, thetaDf = NULL,
  thetaIsChol = FALSE, nStud = 1L, sigma = NULL, sigmaDf = NULL,
  sigmaIsChol = FALSE, nCoresRV = 1L, nObs = 1L, dfSub = 0, dfObs = 0,
  simSubjects = TRUE)
}
\arguments{
\item{params}{Named Vector of RxODE model parameters}

\item{omega}{Named omega matrix.}

\item{omegaDf}{The degrees of freedom of a t-distribution for
simulation.  By default this is \code{NULL} which is
equivalent to \code{Inf} degrees, or to simulate from a normal
distribution instead of a t-distribution.}

\item{omegaIsChol}{Indicates if the \code{omega} supplied is a
Cholesky decomposed matrix instead of the traditional
symmetric matrix.}

\item{nSub}{Number between subject variabilities (ETAs) simulated for every 
realization of the parameters.}

\item{thetaMat}{Named theta matrix.}

\item{thetaDf}{The degrees of freedom of a t-distribution for
simulation.  By default this is \code{NULL} which is
equivalent to \code{Inf} degrees, or to simulate from a normal
distribution instead of a t-distribution.}

\item{thetaIsChol}{Indicates if the \code{theta} supplied is a
Cholesky decomposed matrix instead of the traditional
symmetric matrix.}

\item{nStud}{Number virtual studies to characterize uncertainty in estimated 
parameters.}

\item{sigma}{Matrix for residual variation.  Adds a "NA" value for each of the 
indivdual parameters, residuals are updated after solve is completed.}

\item{sigmaDf}{Degrees of freedom of the sigma t-distribution.  By
default it is equivalent to \code{Inf}, or a normal distribution.}

\item{sigmaIsChol}{Boolean indicating if the sigma is in the
Cholesky decomposition instead of a symmetric covariance}

\item{nCoresRV}{Number of cores used for the simulation of the
sigma variables.  By default this is 1. This uses the package
\code{\link[mvnfast]{rmvn}} and \code{\link[mvnfast]{rmvt}}.
To reproduce the results you need to run on the same platform
with the same number of cores. This is the reason this is set
to be one, regardless of what the number of cores are used in
threaded ODE solving.}

\item{nObs}{Number of observations to simulate (with \code{sigma} matrix)}

\item{dfSub}{Degrees of freedom to sample the between subject variaiblity matrix from the 
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{dfObs}{Degrees of freedom to sample the unexplained variaiblity matrix from the 
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{simSubjects}{boolean indicated RxODE should simulate subjects in studies (\code{TRUE}, 
default) or studies (\code{FALSE})}
}
\description{
Simulate Parameters from a Theta/Omega specification
}
\author{
Matthew L.Fidler
}
