library(RxODE);
context("Test Inis");
rxPermissive({
    out <- RxODE("ini = 1; fun_ini = 2; fun = 4; addit = ini + fun_ini + pi + no_ini")

    test_that("Initial constants are correct",{
        expect_equal(rxInits(out)["pi"],c(pi=pi));
        expect_equal(rxInits(out)["ini"],c(ini=1));
        expect_equal(rxInits(out)["fun_ini"],c(fun_ini=2));
        expect_equal(rxInits(out)["fun"],c(fun=4));
    })

    test_that("Constants are not included in get.modelVars()",{
        expect_equal(out$get.modelVars()$params,c("no_ini"));
    })
    options(RxODE.syntax.allow.ini=FALSE);
    out2 <- RxODE("ini = 1; fun_ini = 2; fun = 4; addit = ini + fun_ini + pi + no_ini")

    test_that("Initial constants only include pi.", {
        expect_equal(names(rxInits(out2)), "pi");
        expect_true(rxDll(out) != rxDll(out2));
        expect_equal(out2$get.modelVars()$params,c("no_ini"));
    })
    options(RxODE.syntax.allow.ini=TRUE);

    ## out <- RxODE({
    ##     theta[1] = 3
    ##     eta[1] = 2
    ##     k = exp(theta[1] + eta[1])
    ##     d / dt(central) = -theta[1] * central
    ## })

    ## test_that("Allow THETA[#] and ETA[#]s.", {
    ## })

    fini <- RxODE({
        C2 = centr/V2;
        C3 = peri/V3;
        d/dt(depot) =-KA*depot;
        d/dt(centr) = KA*depot - CL*C2 - Q*C2 + Q*C3;
        d/dt(peri)  =                    Q*C2 - Q*C3;
        d/dt(eff)  = Kin - Kout*(1-C2/(EC50+C2))*eff;
        eff(0) = theta1  + eta1;
    })

    theta <-
        c(KA=2.94E-01, CL=1.86E+01, V2=4.02E+01, # central
          Q=1.05E+01,  V3=2.97E+02,              # peripheral
          Kin=1, Kout=1, EC50=200, eta1=0, theta1=1)   # effects

    ev <- eventTable(amount.units='mg', time.units='hours')
    ev$add.dosing(dose=10000, nbr.doses=10, dosing.interval=12)
    ev$add.dosing(dose=20000, nbr.doses=5, start.time=120, dosing.interval=24)
    ev$add.sampling(0:240)

    s <- fini %>% solve(theta, ev)

    expect_equal(as.data.frame(s)[1, "eff"], 1)

    theta["eta1"] <- 0.5;

    s <- fini %>% solve(theta, ev)
    expect_equal(as.data.frame(s)[1, "eff"], 1.5)

    theta["eta1"] <- -0.5;

    s <- fini %>% solve(theta, ev)
    expect_equal(as.data.frame(s)[1, "eff"], 0.5)

}, silent=TRUE)
