% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaSampleData}
\alias{tsEvaSampleData}
\title{tsEvaSampleData Function}
\usage{
tsEvaSampleData(
  ms,
  meanEventsPerYear,
  minEventsPerYear,
  minPeakDistanceInDays,
  tail = NA
)
}
\arguments{
\item{ms}{A matrix containing the time series data.}

\item{meanEventsPerYear}{The mean number of events per year.}

\item{minEventsPerYear}{The minimum number of events per year.}

\item{minPeakDistanceInDays}{The minimum peak distance in days.}

\item{tail}{The tail to be studied for POT selection, either 'high' or 'low'.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{completeSeries}}{The complete time series data.}
\item{\code{POT}}{The data for Peaks Over Threshold (POT) analysis.}
\item{\code{years}}{The years in the time series data.}
\item{\code{Percentiles}}{The desired percentiles and their corresponding values.}
\item{\code{annualMax}}{The annual maximum values.}
\item{\code{annualMaxDate}}{The dates corresponding to the annual maximum values.}
\item{\code{annualMaxIndx}}{The indices of the annual maximum values.}
\item{\code{monthlyMax}}{The monthly maximum values.}
\item{\code{monthlyMaxDate}}{The dates corresponding to the monthly maximum values.}
\item{\code{monthlyMaxIndx}}{The indices of the monthly maximum values.}
}
}
\description{
\code{tsEvaSampleData} is a function that calculates various statistics
and data for time series evaluation.
}
\examples{
# Generate sample data
data <- ArdecheStMartin
colnames(data) <- c("Date", "Value")
#select only the 5 latest years
yrs <- as.integer(format(data$Date, "\%Y"))
tokeep <- which(yrs>=2015)
data <- data[tokeep,]
timeWindow <- 365 # 1 year
# Calculate statistics and data
result <- tsEvaSampleData(data, meanEventsPerYear=3, minEventsPerYear=0,
minPeakDistanceInDays=7, "high")
# View the result
print(result)
}
\seealso{
\code{\link[=tsGetPOT]{tsGetPOT()}}
}
