% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_arena.R
\name{read_arena}
\alias{read_arena}
\title{Read an arena description.}
\usage{
read_arena(filename, description = NULL)
}
\arguments{
\item{filename}{A file specifying the arena.}

\item{description}{A data.frame containing parameters specifying the arena.
If supplied, the \code{filename} argument will be ignored. This is intended
for internal use only and can be ignored.}
}
\value{
An \code{rtrack_arena} object containing a representation of the
  arena, which can be passed to \code{\link{read_path}}.
}
\description{
The user will normally not need to call this function directly. Use
\code{\link{read_experiment}} instead.
}
\details{
Every path must be accompanied by a description of the "arena". This
description includes arena size, goal coordinates etc.{} and is unique for
every combination of these (i.e. a different arena description file is
required for goal reversal trials).

The \code{type} parameter specifies the type of experiment. Current options
are \code{mwm} (for Morris water maze), \code{barnes} (Barnes maze),
\code{oft} (open field test), \code{nor} (novel object recognition task) and
\code{apa} (active place avoidance, also known as the carousel maze). For the
water maze, Barnes maze and APA, the pool/arena and goal platforms/holes are
restricted to being circular (the square platforms sometimes used for MWM are
approximated by a circle of a diameter equal to the width of the square. This
is because the rotational orientation of square platforms is seldom recorded
(the behaviour of the package regarding this detail may be changed in future
versions).

This function does not need to be explicitly called if
\code{\link{read_experiment}} is being used (in that case, specify the arena
file names in the column "_Arena").

Quadrants are defined such that the goal is centred around the north
quadrant. Note that this means that the quadrant assignment will change in
the case of a goal reversal experiment. This simplifies the experiment set-up
considerably without imposing restrictions on more complex (e.g. multiple
reversal) study designs.
}
\examples{
require(Rtrack)
arena_description <- system.file("extdata", "Arena.txt", package = "Rtrack")
arena <- read_arena(arena_description)

}
\seealso{
\code{\link{read_path}}, and also \code{\link{read_experiment}} for
  processing many tracks at once.
}
