% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_experiment.R
\name{subset_experiment}
\alias{subset_experiment}
\title{Subset an experiment.}
\usage{
subset_experiment(experiment, tracks = "all")
}
\arguments{
\item{experiment}{An \code{rtrack_experiment} object from
\code{\link{read_experiment}}.}

\item{tracks}{Which tracks should be retained in the subset. Default, 'all', will return the same experiment object. A subset of tracks can be specified using either
numeric indices or a vector of track IDs following usual R standards.}
}
\value{
An \code{rtrack_experiment} containing a subset of the metrics, factors (and strategies if present in the original object).
}
\description{
Creates a new experiment object that is a subset of another.
}
\examples{
require(Rtrack)
experiment.description <- system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
experiment <- read_experiment(experiment.description, format = "excel",
  project.dir = system.file("extdata", "", package = "Rtrack"))
# The code below returns an experiment object only containing strain "B6". 
# Use the parameter 'file' to write to a file instead.
b6.tracks = experiment$factors$Strain == "B6"
b6.experiment = subset_experiment(experiment, tracks = b6.tracks)

}
