% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_mwm_strategy_garthe.R
\name{call_mwm_strategy_garthe}
\alias{call_mwm_strategy_garthe}
\title{Strategy classification using the legacy Garthe classifier.}
\usage{
call_mwm_strategy_garthe(metrics, parameters = NULL)
}
\arguments{
\item{metrics}{An \code{rtrack_metrics} object from
\code{\link{calculate_metrics}} or a list of such objects.}

\item{parameters}{A \code{\link[base]{data.frame}} of parameters to adjust
output. Currently not implemented.}
}
\value{
An \code{rtrack_strategies} object. The \code{calls} element contains
  the called strategy/strategies as well as several additional metrics
  generated by this method.
}
\description{
Calculates strategies using a method based on Garthe et. al. 2009.
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.csv", package = "Rtrack")
arena_description <- system.file("extdata", "Arena_SW.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "ethovision.3.csv")
metrics <- calculate_metrics(path, arena)
strategies <- call_mwm_strategy_garthe(metrics)
# Inspect the strategy call
strategies$calls

}
\seealso{
\code{\link{call_strategy}}.
}
