% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkbuild.R
\name{pkbuild}
\alias{pkbuild}
\title{Automatic PK model building}
\usage{
pkbuild(
  data = NULL,
  project = NULL,
  stat = FALSE,
  param = "clearance",
  new.dir = ".",
  MM = FALSE,
  linearization = F,
  criterion = "BICc",
  level = NULL,
  settings.stat = NULL
)
}
\arguments{
\item{data}{a list with fields
\itemize{
  \item \code{dataFile}: path of a formatted data file
  \item \code{headerTypes}: a vector of strings
  \item \code{administration} ("iv", "bolus", "infusion", "oral", "ev"): route of administration 
}}

\item{project}{a Monolix project}

\item{stat}{({FALSE}, TRUE): the statistical model is also built (using buildmlx)}

\item{param}{({"clearance"}, "rate", "both): parameterization}

\item{new.dir}{name of the directory where the created files are stored 
(default is the current working directory) )}

\item{MM}{({FALSE}, TRUE): tested models include or not Michaelis Menten elimination models}

\item{linearization}{TRUE/{FALSE} whether the computation of the likelihood is based on a linearization of the model (default=FALSE)}

\item{criterion}{penalization criterion to optimize c("AIC", "BIC", {"BICc"}, gamma)}

\item{level}{an integer between 1 and 9 (used by setSettings)}

\item{settings.stat}{list of settings used by buildmlx (only if stat=TRUE)}
}
\value{
A list of results
}
\description{
Fit several structural PK models and select the best one based on a Bayesian Information Criterion.
Models to compare can be defined by rate constants and/or clearances and can include or not nonlinear elimination
models.
See https://monolix.lixoft.com/rsmlx/pkbuild/ for more details.
}
\examples{
\dontrun{
# Build a PK model for the warfarin PK data. 
# By default, only models using clearance (and inter compartmental clearances) are used
warf.pk1 <- pkbuild(data=warfarin)

# Models using elimination and transfer rate constants are used, 
# as well as nonlinear elimination models
warf.pk2 <- pkbuild(data=warfarin,  new.dir="warfarin", param="rate", MM=TRUE)

# Both models using clearances and rates are used. 
# Level is set to 7 in order to get accurate results.
warf.pk3 <- pkbuild(data=warfarin,  new.dir="warfarin", param="both", level=7)
}
}
