% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_frequencies.R
\name{grouped_sum_freqs}
\alias{grouped_sum_freqs}
\title{Grouped Frequencies}
\usage{
grouped_sum_freqs(data, small.level, big.level, w = NULL)
}
\arguments{
\item{data}{(dataframe) Data to analize}

\item{small.level}{(string vector) All variables to get grouped sum that will sum up to 100}

\item{big.level}{(string vector) Must be fully contained in variables from small.level}

\item{w}{(string) Numeric variable from which to get weights (optional)}
}
\value{
Dataframe with frequencies from the grouped sum of small.level and big.level used for getting percentages
}
\description{
Compute a DataFrame with frequency counts obtained from the sum of 'small.level' and 'big.level' after grouping, which can be used to calculate percentages.
}
\examples{
grouped_sum_freqs(data = mtcars,small.level = c("cyl","am"),big.level = c("cyl"))

}
