% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{RprobitB_fit}
\alias{RprobitB_fit}
\alias{summary.RprobitB_fit}
\title{Create object of class \code{RprobitB_fit}}
\usage{
RprobitB_fit(
  data,
  scale,
  level,
  normalization,
  R,
  B,
  Q,
  latent_classes,
  prior,
  gibbs_samples,
  class_sequence,
  comp_time
)

\method{summary}{RprobitB_fit}(object, FUN = c(mean = mean, sd = stats::sd, `R^` = R_hat), ...)
}
\arguments{
\item{data}{An object of class \code{RprobitB_data}.}

\item{scale}{A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{normalization}{An object of class \code{RprobitB_normalization}.}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{latent_classes}{Either \code{NULL} (for no latent classes) or a list of parameters specifying
the number of latent classes and their updating scheme:
\itemize{
\item \code{C}: The fixed number (greater or equal 1) of latent classes,
which is set to 1 per default. If either \code{weight_update = TRUE}
or \code{dp_update = TRUE} (i.e. if classes are updated), \code{C}
equals the initial number of latent classes.
\item \code{weight_update}: A boolean, set to \code{TRUE} to weight-based
update the latent classes. See ... for details.
\item \code{dp_update}: A boolean, set to \code{TRUE} to update the latent
classes based on a Dirichlet process. See ... for details.
\item \code{Cmax}: The maximum number of latent classes.
\item \code{buffer}: The number of iterations to wait before a next
weight-based update of the latent classes.
\item \code{epsmin}: The threshold weight (between 0 and 1) for removing
a latent class in the weight-based updating scheme.
\item \code{epsmax}: The threshold weight (between 0 and 1) for splitting
a latent class in the weight-based updating scheme.
\item \code{distmin}: The (non-negative) threshold in class mean difference
for joining two latent classes in the weight-based updating scheme.
}}

\item{prior}{A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{gibbs_samples}{An object of class \code{RprobitB_gibbs_samples}.}

\item{class_sequence}{The sequence of class numbers during Gibbs sampling of length \code{R}.}

\item{comp_time}{The time spent for Gibbs sampling.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{RprobitB_fit}.
}
\description{
This function creates an object of class \code{RprobitB_fit}.
}
\keyword{internal}
