% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_sampling}
\alias{gibbs_sampling}
\title{Markov chain Monte Carlo simulation for the probit model}
\usage{
gibbs_sampling(
  sufficient_statistics,
  prior,
  latent_classes,
  fixed_parameter,
  init,
  R,
  B,
  print_progress,
  ordered,
  ranked
)
}
\arguments{
\item{sufficient_statistics}{The output of \code{\link{sufficient_statistics}}.}

\item{prior}{A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{latent_classes}{Either \code{NULL} (for no latent classes) or a list of parameters specifying
the number of latent classes and their updating scheme:
\itemize{
\item \code{C}: The fixed number (greater or equal 1) of latent classes,
which is set to 1 per default. If either \code{weight_update = TRUE}
or \code{dp_update = TRUE} (i.e. if classes are updated), \code{C}
equals the initial number of latent classes.
\item \code{weight_update}: A boolean, set to \code{TRUE} to weight-based
update the latent classes. See ... for details.
\item \code{dp_update}: A boolean, set to \code{TRUE} to update the latent
classes based on a Dirichlet process. See ... for details.
\item \code{Cmax}: The maximum number of latent classes.
\item \code{buffer}: The number of iterations to wait before a next
weight-based update of the latent classes.
\item \code{epsmin}: The threshold weight (between 0 and 1) for removing
a latent class in the weight-based updating scheme.
\item \code{epsmax}: The threshold weight (between 0 and 1) for splitting
a latent class in the weight-based updating scheme.
\item \code{distmin}: The (non-negative) threshold in class mean difference
for joining two latent classes in the weight-based updating scheme.
}}

\item{fixed_parameter}{Optionally specify a named list with fixed parameter values for \code{alpha},
\code{C}, \code{s}, \code{b}, \code{Omega}, \code{Sigma}, \code{Sigma_full},
\code{beta}, \code{z}, or \code{d} for the simulation.
See \href{https://loelschlaeger.de/RprobitB/articles/v01_model_definition.html}{the vignette on model definition}
for definitions of these variables.}

\item{init}{The output of \code{\link{set_initial_gibbs_values}}.}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{print_progress}{A boolean, determining whether to print the Gibbs sampler progress and the
estimated remaining computation time.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}

\item{ranked}{TBA}
}
\value{
A list of Gibbs samples for
\itemize{
\item \code{Sigma},
\item \code{alpha} (if \code{P_f>0}),
\item \code{s}, \code{z}, \code{b}, \code{Omega} (if \code{P_r>0}),
\item \code{d} (if \code{ordered = TRUE}),
}
and a vector \code{class_sequence} of length \code{R}, where the \code{r}th
entry is the number of latent classes after iteration \code{r}.
}
\description{
This function draws from the posterior distribution of the probit model via
Markov chain Monte Carlo simulation-
}
\details{
This function is not supposed to be called directly, but rather via
\code{\link{fit_model}}.
}
\keyword{internal}
