# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Routine to initialize the timer for Gibbs sampling
#'
#' @return No return value, called for on-screen information.
#'
start_timer <- function() {
    invisible(.Call(`_RprobitB_start_timer`))
}

#' Routine to update the timer for Gibbs sampling
#'
#' @param rep An integer, current iteration
#' @param R An integer, total number of iterations
#'
#' @return No return value, called for on-screen information.
#'
update_timer <- function(rep, R) {
    invisible(.Call(`_RprobitB_update_timer`, rep, R))
}

#' Routine to terminate the timer for Gibbs sampling
#'
#' @param R An integer, total number of iterations
#'
#' @return No return value, called for on-screen information.
#'
end_timer <- function(R) {
    invisible(.Call(`_RprobitB_end_timer`, R))
}

#' Routine to compute the density of a multivariate normal
#'
#' @param x A matrix, the arguments
#' @param mean A vector, the mean
#' @param sigma A matrix, the covariance matrix
#' @param logd A boolean, wheter to apply the logarithm
#'
#' @return A vector, the computed multivariate normal densities
#'
dmvnrm_arma_mc <- function(x, mean, sigma, logd = FALSE) {
    .Call(`_RprobitB_dmvnrm_arma_mc`, x, mean, sigma, logd)
}

#' Routine to draw from Dirichlet
#'
#' @param alpha A vector, the concentration parameter
#'
#' @return A vector, the sample from the Dirichlet distribution
#'
rdirichlet <- function(alpha) {
    .Call(`_RprobitB_rdirichlet`, alpha)
}

#' Routine to draw from Wishart and inverted Wishart
#'
#' @param nu A double, the degrees of freedom
#' @param V A matrix, the scale matrix
#'
#' @return A list, the draw from the Wishart (W), inverted Wishart (IW), and Cholesky decompositions (C and CI)
#'
rwishart <- function(nu, V) {
    .Call(`_RprobitB_rwishart`, nu, V)
}

#' Routine to perform Gibbs sampling for the LCMMNP model
#'
#' @param R An integer, the number of iterations
#' @param B An integer, the length of the burn-in period
#' @param nprint An integer, the step number for printing the sampling progress
#' @param N An integer, the number (greater or equal one) of decision makers
#' @param Jm1 An integer, one minus the number of choice alternatives (fixed across decision makers and choice occasions)
#' @param P_f An integer, the number of attributes that are connected to fixed coefficients (can be zero)
#' @param P_r An integer, the number of attributes that are connected to random, decision maker specific coefficients (can be zero)
#' @param C An integer, the number of latent classes (ignored if P_r = 0)
#' @param lcus A list, latent class updating scheme parameters
#' @param suff_statistics A list, sufficient statistics
#' @param prior A list, prior parameters
#' @param init A list, initial values for the Gibbs sampler
#'
#' @return A list of Gibbs samples
#'
gibbs_loop <- function(R, B, nprint, N, Jm1, P_f, P_r, C, lcus, suff_statistics, prior, init) {
    .Call(`_RprobitB_gibbs_loop`, R, B, nprint, N, Jm1, P_f, P_r, C, lcus, suff_statistics, prior, init)
}

