% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizationrelationships.update.R
\name{organizationrelationships.update}
\alias{organizationrelationships.update}
\title{Update an organization relationship}
\usage{
organizationrelationships.update(id, org_id = NULL, type = NULL,
  rel_owner_org_id = NULL, rel_linked_org_id = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the organization relationship}

\item{org_id}{ID of the base organization for the returned calculated values}

\item{type}{The type of organization relationship. This field has the following domains: (parent; related)}

\item{rel_owner_org_id}{The owner of this relationship. If type is 'parent', then the owner is the parent and the linked organization is the daughter.}

\item{rel_linked_org_id}{The linked organization in this relationship. If type is 'parent', then the linked organization is the daughter.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update an organization relationship on pipedrive.
}
\examples{
\donttest{
organizationrelationships.update(id='e.g.',api_token='token',company_domain='exp')
}
}
