% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activities.get_all.R
\name{activities.get_all}
\alias{activities.get_all}
\title{Get all activities assigned to a particular user}
\usage{
activities.get_all(user_id = NULL, filter_id = NULL, type = NULL,
  start = NULL, limit = NULL, start_date = NULL, end_date = NULL,
  done = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{user_id}{ID of the user whose activities will be fetched. If omitted, the user associated with the API token will be used. If 0, activities for all company users will be fetched based on the permission sets.}

\item{filter_id}{ID of the filter to use (will narrow down results if used together with user_id parameter).}

\item{type}{Type of the activity, can be one type or multiple types separated by a comma. This is in correlation with the key_string parameter of ActivityTypes.}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{start_date}{Date in format of YYYY-MM-DD from which activities to fetch from.}

\item{end_date}{Date in format of YYYY-MM-DD until which activities to fetch to.}

\item{done}{Whether the activity is done or not. 0 = Not done, 1 = Done. If omitted returns both Done and Not done. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get all activities assigned to a particular user from pipedrive.
}
\examples{
\donttest{
activities.get_all(api_token='token',company_domain='exp')
}
}
