% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhirBulkClient.R
\name{fhirBulkClient}
\alias{fhirBulkClient}
\title{fhirBulkClient}
\description{
Bulk data client in R for FHIR STU 3.
}
\section{Usage}{

\preformatted{
bulkclient <- fhirBulkClient$new(endpoint, tokenURL = NULL, token = NULL)

bulkclient$patientExport(criteria = NULL)
bulkclient$groupExport(groupId, criteria = NULL)
bulkclient$wholeSystemExport(criteria = NULL)
bulkclient$getBulkStatus()
bulkclient$downloadBulk(requestNumber, returnType = "parsed" ,deleteFromQueue = TRUE)
bulkclient$deleteBulkRequest(requestNumber)
bulkclient$retrieveToken(jwt, scopes, tokenURL = NULL)
bulkclient$setToken(token)

print(bulkclient)
}
}

\section{Arguments}{

\describe{
  \item{bulkclient}{A \code{fhirBulkClient} object.}
  \item{endpoint}{The URL of the server to connect to.}
  \item{tokenURL}{Authorization server’s endpoint.}
  \item{token}{Acces token.}
  \item{criteria}{The search parameters to filter the Resources on. Each given string is a combined key/value pair (separated by '=').}
  \item{groupId}{Id of the Group resource.}
  \item{requestNumber}{Number of the request in the queue.}
  \item{returnType}{Specify the return type. This can be "parsed" or "ndjson".}
  \item{deleteFromQueue}{If the request needs to be deleted from the queue after it's been downloaded.}
  \item{jwt}{JSON Web Token signed with the app's private key (RSA SHA-256).}
  \item{scopes}{Desired scope(s).}
}
}

\section{Details}{

\code{$new()} Creates a new fhirBulkClient using a given endpoint.
If the endpoint does not end with a slash (/), it will be added.

\code{$patientExport()} Request all data on all patients. Possible to filter the results with the _outputFormat, _since and _type parameters. The request will be added to the queue.

\code{$groupExport()} Request all data of a patientgroup. Possible to filter the results with the _outputFormat, _since and _type parameters. The request will be added to the queue.

\code{$wholeSystemExport()} Request all data. Possible to filter the results with the _outputFormat, _since and _type parameters. The request will be added to the queue.

\code{$getBulkStatus()} Update and return the queue to see the progress of your requests.

\code{$downloadBulk()} Download a request from the queue.

\code{$deleteBulkRequest()} Cancel a request from the queue.

\code{$retrieveToken()} Retrieve a token from the authentication server.

\code{$setToken} Set a token.

\code{print(p)} or \code{p$print()} Shows which endpoint is configured.
}

\examples{
\dontrun{
# Read your private key
privatekey <- openssl::read_key("PrivateKey.pem")

# Create your claim
claim <- jose::jwt_claim(iss = "ServiceURL",
                         sub = "ClientID",
                         aud = "TokenURL",
                         
			                    # expiration date as epoch (5 minutes)
                         exp = as.integer(as.POSIXct( Sys.time() + 300)), 
                         
   			                # 'random' number
                         jti = charToRaw(as.character(runif(1, 0.5, 100000000000)))) 

# Sign your claim with your private key
jwt <- jose::jwt_encode_sig(claim, privatekey)

# Define your scope(s)
scopes <- c("system/*.read", "system/CommunicationRequest.write")

# Create a new fhirBulkClient
bulkclient <- fhirBulkClient$new("FHIRBulkServerURL", tokenURL = "TokenURL")

# Retrieve your token
token <- bulkclient$retrieveToken(jwt, scopes)

# Set your token
bulkclient$setToken(token$access_token)

# Request a download for Patient Cohort 3
bulkclient$groupExport(3)

# Request the progress of the requests
bulkclient$getBulkStatus()

# When the downloads a available, download the bulkdata
patient_cohort_3 <- bulkclient$downloadBulk(1)

View(patient_cohort_3)
}

}
