% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixL.short.R
\docType{methods}
\name{mixLp}
\alias{mixLp}
\alias{mixLp,formula,ANY,numeric,numeric-method}
\alias{CTLE,formula,ANY,numeric,numeric-method}
\title{mixLp : mixLp_one estimates the mixture regression parameters robustly using Laplace distribution based on multiply initial value..}
\usage{
mixLp(formula, data, nc=2, nit=200)

\S4method{mixLp}{formula,ANY,numeric,numeric}(formula, data, nc = 2,
  nit = 20)
}
\arguments{
\item{formula}{A symbolic description of the model to be fit.}

\item{data}{A data frame containing the predictor and response variables, where the last column is the response varible.}

\item{nc}{Number of mixture components.}

\item{nit}{Number of iterations}
}
\value{
Estimated coefficients of all components.
}
\description{
mixLp estimates the mixture regression parameters robustly using bisquare function based on multiple initial values. The solution is found by the modal solution.
}
\examples{
library("RobMixReg")
formula01=as.formula("y~x")
x=(gaussData$x);y=as.numeric(gaussData$y);
example_data01=data.frame(x,y)
res = mixLp(formula01, example_data01, nc=2, nit=20)
}
