% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.RoBSA}
\alias{predict.RoBSA}
\title{Predict method for RoBSA objects.}
\usage{
\method{predict}{RoBSA}(
  object,
  time = NULL,
  new_data = NULL,
  predictor = NULL,
  covariates_data = NULL,
  type = c("survival", "hazard", "density", "mean", "sd"),
  summarize = TRUE,
  averaged = TRUE,
  conditional = FALSE,
  samples = 10000,
  ...
)
}
\arguments{
\item{object}{a fitted RoBSA object}

\item{time}{a vector of time values at which the survival/hazard/density
will be predicted (for each passed data point)}

\item{new_data}{a data.frame containing fully specified predictors for which
predictions should be made}

\item{predictor}{an alternative input to \code{new_data} that automatically
generates predictions for each level of the predictor across all either across
levels of covariates specified by \code{covariates_data} or at the default values
of other predictors}

\item{covariates_data}{a supplementary input to \code{predictor} that specifies
levels of covariates for which predictions should be made}

\item{type}{what type of prediction should be created}

\item{summarize}{whether the predictions should be aggregated as mean and sd.
Otherwise, prediction for for posterior samples is returned.}

\item{averaged}{whether predictions should be combined with Bayesian model-averaging
or whether predictions for each individual model should be returned.}

\item{conditional}{whether only models assuming presence of the specified
\code{predictor} should be used}

\item{samples}{number of posterior samples to be evaluated}

\item{...}{additional arguments (unused)}
}
\value{
a list with predictions (or a list of lists in case that predictions for each
individual model are requested \code{averaged = FALSE})
}
\description{
Predicts survival/hazard/density/mean/sd for a given
RoBSA object. Either predicts values for each row of a fully specified
\code{new_data} data.frame, or for all levels of a given \code{predictor}
at the mean of continuous covariate values and default factor levels or
covariate values specified as \code{covariates_data} data.frame.
}
