% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnlfilename.R
\name{getNlTileTifLclNamePath}
\alias{getNlTileTifLclNamePath}
\title{Constructs the full path used to save/access the downloaded tile .tgz file}
\usage{
getNlTileTifLclNamePath(nlType,
  configName = pkgOptions(paste0("configName_", nlType)), nlPeriod,
  tileNum)
}
\arguments{
\item{nlType}{character string the nlType}

\item{configName}{character the type of raster being processed}

\item{nlPeriod}{the nlPeriod in which the tile was created}

\item{tileNum}{the index of the tile as given in nlTileIndex}
}
\value{
a character string filename of the compressed .tgz VIIRS tile
}
\description{
Constructs the full path used to save/access the downloaded tile .tgz file
}
\examples{
\dontrun{
Rnightlights:::getNlTileZipLclNamePath("OLS.Y", "2012", 1)
 #returns "/dataPath/OLS.Y_2012_00N180W.tgz"
 }

\dontrun{
Rnightlights:::getNlTileZipLclNamePath("VIIRS.M", "201412", 1)
 #returns "/dataPath/VIIRS.M_201412_75N180W.tgz"
 }

}
