% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_comments_reactions.R
\name{get_comments_reactions}
\alias{get_comments_reactions}
\title{GET comments reactions}
\usage{
get_comments_reactions(file_key, comment_id, cursor = NULL)
}
\arguments{
\item{file_key}{string. The key that a Figma file is referred by.}

\item{comment_id}{string. The comment id.}

\item{cursor}{string obtained from the result of the previous request, a
cursor for pagination.}
}
\value{
S3 object of class `rigma_get_comments_reactions`. Contains the parsed
JSON response with fields `reactions`, and `pagination`.
}
\description{
Obtains a paginated list of the comments' reactions.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
#navigate to  file and get key from url
file_key <- "sFHgQh9dL6369o5wrZHmdR"
resp <- get_comments(file_key)
resp_reactions <- get_comments_reactions(file_key, resp$comments[[1]]$id)
}
\dontshow{\}) # examplesIf}
}
