% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_cont_R.R
\name{power_cont_R}
\alias{power_cont_R}
\title{Find the power of various gof tests for continuous data.}
\usage{
power_cont_R(
  pnull,
  rnull,
  ralt,
  param_alt,
  phat = function(x) -99,
  TS,
  typeTS,
  TSextra,
  alpha = 0.05,
  B = 1000,
  maxProcessor
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{rnull}{function to generate data under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{phat}{=function(x) -99, function to estimate parameters from the data, or -99 if no parameters are estimated}

\item{TS}{user supplied function to find test statistics, if any}

\item{typeTS}{format of TS routine}

\item{TSextra}{list provided to TS}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{B}{=1000 number of simulation runs}

\item{maxProcessor}{maximum of number of processors to use, 1 if no parallel processing is needed or number of cores-1 if missing}
}
\value{
A numeric matrix of power values
}
\description{
Find the power of various gof tests for continuous data.
}
