% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{gtf_to_gff3}
\alias{gtf_to_gff3}
\title{Converts a GTF file into a GFF3 file}
\usage{
gtf_to_gff3(gtfFile, outFile, forceOverwrite = FALSE)
}
\arguments{
\item{gtfFile}{Path to the input GTF file}

\item{outFile}{Path to the output GFF3 file, inf not provided the output will be gtfFile.gff3}

\item{forceOverwrite}{If output file exists, overwrite the existing file. (default FALSE)}
}
\value{
Path to the generated GFF3 file
}
\description{
This function converts a GTF file into a GFF3 file mantaining the feature hierarchy
defined by the gene_id and transcript_id attributes. The remaining attributes of each feature
will be kept with the same name and value.
}
\examples{
\dontrun{
test_gtf<-system.file("extdata", "AthSmall.gtf", package="Rgff")
gtf_to_gff3(test_gtf)
}
}
