% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.funts}
\alias{as.funts}
\title{Convert Object to a funts}
\usage{
as.funts(obj, basis = NULL)
}
\arguments{
\item{obj}{the object to be converted. It can be an object of class \code{\link{fd}} (functional data) of the package `fda`, \code{\link{fts}} (functional time series) of the package `rainbow` types.}

\item{basis}{an optional argument specifying the basis to be used for the resulting \code{\link{funts}} object when converting from \code{\link{fts}} objects. If not provided, a B-spline basis will be created by default.}
}
\value{
An object of class \code{\link{funts}}.
}
\description{
This function allows you to convert various types of objects into a functional time series (\code{\link{funts}}) object.
}
\note{
Only objects of class \code{\link{fd}} (functional data) and \code{\link{fts}} (functional time series) can be converted to a \code{\link{funts}} object. Other types will result in an error.
}
\examples{
require(rainbow)
class(Australiasmoothfertility)
x_funts1 <- as.funts(Australiasmoothfertility)
plot(x_funts1, main = "Australians Fertility")

require(fda)
bs <- create.bspline.basis(rangeval = c(15, 49), nbasis = 13)
fd_obj <- smooth.basis(argvals = Australiasmoothfertility$x, Australiasmoothfertility$y, bs)$fd

x_funts <- as.funts(fd_obj)
plotly_funts(x_funts,
  main = "Australians Fertility",
  ylab = "Fertility rate",
  xlab = "Age"
)
}
\seealso{
\code{\link{funts}}, \code{\link{create.bspline.basis}}
}
