% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTSclass.R
\name{fts}
\alias{fts}
\title{Functional Time Series Class}
\usage{
fts(X, B, grid, time = NULL)
}
\arguments{
\item{X}{A list of length p where p is a positive integer specifying the number of variables observed in the fts. Each entry in the list should be a matrix or an array.}

\item{B}{A list of length p. Each entry in the list should be either a matrix specifying the basis for each variable or each list entry should be a list specifying the number of basis elements and desired basis type to be used in the smoothing process.}

\item{grid}{A list of length p. Each entry in the list should either be a numeric or a list of numeric elements depending on the dimension of the domain the variable is observed over.}

\item{time}{A character vector where each entry specifies the time an observation is made.}
}
\description{
This function is used to create functional time series (\code{\link{fts}}) objects from lists of discretely sampled data, basis specifications, and grid elements which provide the domain that each variable is observed over. Each variable is assumed to be observed over a regular and equidistant grid. In addition, each variable in the fts is assumed to be observed over a one or two-dimensional domain.
}
\note{
Refer to \code{\link{fssa}} for examples on how to run this function.
}
\seealso{
\code{\link{fssa}}
}
