% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftsarithmetic.R
\name{[.fts}
\alias{[.fts}
\title{Indexing into Functional Time Series}
\usage{
\method{[}{fts}(Y, i = "index")
}
\arguments{
\item{Y}{An object of class \code{\link{fts}}.}

\item{i}{The index value.}
}
\value{
An object of class \code{\link{fts}}.
}
\description{
An indexing method for functional time series (\code{\link{fts}}).
}
\examples{
\dontrun{
require(Rfssa)
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Callcenter.RData")
D <- matrix(sqrt(Callcenter$calls), nrow = 240)
u <- seq(0, 1, length.out = 240) # Define domain of functional data
d <- 22 # number of basis elements
Y <- fts(list(D), list(list(d, "bspline")), list(u))
plot(Y)
plot(Y[10:15])
}

}
\seealso{
\code{\link{fts}}
}
