\name{ Permutation }
\alias{permutation}
\alias{permutation.next}
\alias{permutation.prev}
\title{
Permutation
}

\description{
Permute the given vector.
}

\usage{
permutation(x, all=TRUE)
permutation.next(x, all.next=TRUE)
permutation.prev(x, all.prev=TRUE)
}

\arguments{
\item{x}{
A numeric vector with data. 
}
\item{all}{
A logical value for returning all or one possible combinations. 
}
\item{all.next}{
A logical value for returning all the next or one possible combinations, if there are. 
}
\item{all.prev}{
A logical value for returning all the previous or one possible combinations, if there are. 
}
}

\details{
This function implements "Permutation", which means all the possible combinations. In the permutation.next and permutation.prev
if there aren't possible combinations it returns the same vector.
}

\value{
Returns a matrix with all possible combinations of the given vector or a matrix row with one possible combinations.
}

\author{
Manos Papadakis

R implementation and documentation: Manos Papadakis <papadakm95@gmail.com>
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{combn},\link{comb_n}
}
}

\examples{
y <- rnorm(5)
b <- permutation(y)
b <- permutation.next(y)
b <- permutation.prev(y)
}

\keyword{ Permutation Function }