% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Require-helpers.R
\name{dlArchiveVersionsAvailable}
\alias{dlArchiveVersionsAvailable}
\alias{available.packagesCached}
\title{Available and archived versions}
\usage{
dlArchiveVersionsAvailable(
  package,
  repos = getOption("repos"),
  verbose = getOption("Require.verbose")
)

available.packagesCached(
  repos,
  purge,
  verbose = getOption("Require.verbose"),
  returnDataTable = TRUE,
  type
)
}
\arguments{
\item{package}{A single package name (without version or github specifications)}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to either
\code{install.packages}, \code{install_github} or \code{installVersions}.}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}

\item{purge}{Logical. Should all caches be purged? Default is
\code{getOption("Require.purge", FALSE)}. There is a lot of internal caching of
results throughout the \code{Require} package. These help with speed and reduce
calls to internet sources. However, sometimes these caches must be purged.
The cached values are renewed when found to be too old, with the age limit.
This maximum age can be set in seconds with the environment variable
\code{R_AVAILABLE_PACKAGES_CACHE_CONTROL_MAX_AGE}, or if unset, defaults to 3600
(one hour -- see \code{\link[utils:available.packages]{utils::available.packages}}).

Internally, there are calls to \code{available.packages}.}

\item{returnDataTable}{Logical. If \code{TRUE}, the default, then the return
is a data.table.
Otherwise, it is a \code{matrix}, as per \code{available.packages}}

\item{type}{See \code{utils::install.packages}}
}
\description{
These are wrappers around available.packages and also get the archived versions
available on CRAN.
}
\details{
\code{dlArchiveVersionsAvailable} searches CRAN Archives for available versions.
It has been borrowed from a sub-set of the code in a non-exported function:
\code{remotes:::download_version_url}
}
