% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_padog}
\alias{KO_padog}
\title{Perform Pathway Analysis with Down-weighting of Overlapping Genes (PADOG)}
\usage{
KO_padog(
  reporter_res,
  verbose = TRUE,
  perm = 1000,
  p.adjust.method = "BH",
  ...
)
}
\arguments{
\item{reporter_res}{The input reporter result.}

\item{verbose}{If TRUE, print verbose messages. Default is TRUE.}

\item{perm}{The number of permutations. Default is 1000.}

\item{p.adjust.method}{Method for p-value adjustment. Default is "BH".}

\item{...}{Additional parameters to be passed to \code{\link[PADOG]{padog}} function.}
}
\value{
A data frame containing PADOG results for KO enrichment.

A data frame with columns "ID," "Description," "K_num," "Exist_K_num," "p.value," and "p.adjust."
}
\description{
Perform Pathway Analysis with Down-weighting of Overlapping Genes (PADOG)
}
\examples{
\donttest{
## use `PADOG` from the `PADOG` package.
if (requireNamespace("PADOG")) {
  data("reporter_score_res")
  padog_res <- KO_padog(reporter_score_res,
    verbose = TRUE,
    perm = 200, p.adjust.method = "none"
  )
}
}
}
\seealso{
Other common_enrich: 
\code{\link{KO_enrich}()},
\code{\link{KO_fisher}()},
\code{\link{KO_gsa}()},
\code{\link{KO_gsea}()},
\code{\link{KO_gsva}()},
\code{\link{KO_safe}()},
\code{\link{KO_sea}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
