% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_gsea}
\alias{KO_gsea}
\title{Perform gene set enrichment analysis}
\usage{
KO_gsea(
  ko_stat,
  weight = "logFC",
  add_mini = NULL,
  p.adjust.method = "BH",
  type = c("pathway", "module")[1],
  feature = "ko",
  modulelist = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ko_stat}{ko_stat dataframe from \code{\link[ReporterScore]{ko.test}}.}

\item{weight}{the metric used for ranking, default: logFC}

\item{add_mini}{add_mini when calculate the logFC. e.g (10+0.1)/(0+0.1), default 0.05*min(avg_abundance)}

\item{p.adjust.method}{The method used for p-value adjustment (default: "BH").}

\item{type}{"pathway" or "module" for default KOlist_file.}

\item{feature}{one of "ko", "gene", "compound"}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{verbose}{logical}
}
\value{
DOSE object
}
\description{
Perform gene set enrichment analysis
}
\examples{
message("The following example require some time to run:")
\donttest{
## use `GSEA` from the `clusterProfiler` package.
if (requireNamespace("clusterProfiler")) {
  data("reporter_score_res")
  gsea_res <- KO_gsea(reporter_score_res, p.adjust.method = "none")
  enrichplot::gseaplot(gsea_res, geneSetID = data.frame(gsea_res)$ID[1])
  gsea_res_df <- as.enrich_res(gsea_res)
  plot(gsea_res_df)
}
}
}
\seealso{
Other common_enrich: 
\code{\link{KO_enrich}()},
\code{\link{KO_fisher}()},
\code{\link{KO_gsa}()},
\code{\link{KO_gsva}()},
\code{\link{KO_padog}()},
\code{\link{KO_safe}()},
\code{\link{KO_sea}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
