% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_features_box}
\alias{plot_features_box}
\alias{plot_KOs_box}
\title{Plot features boxplot}
\usage{
plot_features_box(
  kodf,
  group = NULL,
  metadata = NULL,
  map_id = "map00780",
  select_ko = NULL,
  only_sig = FALSE,
  box_param = NULL,
  modulelist = NULL,
  KO_description = FALSE,
  str_width = 50
)
}
\arguments{
\item{kodf}{KO_abundance table, rowname is ko id (e.g. K00001),colnames is samples. or result of `get_reporter_score`}

\item{group}{The compare group (two category) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of kodf.}

\item{metadata}{metadata}

\item{map_id}{the pathway or module id}

\item{select_ko}{select which ko}

\item{only_sig}{only show the significant features}

\item{box_param}{parameters pass to \code{\link[pcutils]{group_box}}}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{KO_description}{show KO description rather than KO id.}

\item{str_width}{str_width to wrap}
}
\value{
ggplot
}
\description{
Plot features boxplot
}
\examples{
\donttest{
data("reporter_score_res")
plot_features_box(reporter_score_res,
    select_ko = c("K00059", "K00208", "K00647", "K00652", "K00833", "K01012")
)
plot_features_box(reporter_score_res, select_ko = "K00059", KO_description = TRUE)
}
}
