/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.TblPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolver {
    private static Logger log = LoggerFactory.getLogger(PropertyResolver.class);
    private PPr documentDefaultPPr;
    private RPr documentDefaultRPr;
    private StyleDefinitionsPart styleDefinitionsPart;
    private WordprocessingMLPackage wordMLPackage;
    private Styles styles;
    private Map<String, Style> liveStyles = null;
    private ThemePart themePart;
    private NumberingDefinitionsPart numberingDefinitionsPart;
    private Map<String, PPr> resolvedStylePPrComponent = new HashMap<String, PPr>();
    private Map<String, RPr> resolvedStyleRPrComponent = new HashMap<String, RPr>();
    CTLanguage themeFontLang = null;
    String defaultParagraphStyleId;
    String defaultCharacterStyleId;
    ObjectFactory factory = new ObjectFactory();

    public RPr getDocumentDefaultRPr() {
        return this.documentDefaultRPr;
    }

    public PropertyResolver(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.wordMLPackage = wordMLPackage;
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        this.styleDefinitionsPart = mdp.getStyleDefinitionsPart(true);
        this.themePart = mdp.getThemePart();
        this.numberingDefinitionsPart = mdp.getNumberingDefinitionsPart();
        if (wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() != null) {
            this.themeFontLang = ((CTSettings)wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getContents()).getThemeFontLang();
        }
        this.init();
    }

    private void init() throws Docx4JException {
        this.styleDefinitionsPart.createVirtualStylesForDocDefaults();
        this.defaultParagraphStyleId = this.styleDefinitionsPart.getDefaultParagraphStyle().getStyleId();
        this.defaultCharacterStyleId = this.styleDefinitionsPart.getDefaultCharacterStyle().getStyleId();
        this.styles = (Styles)this.styleDefinitionsPart.getJaxbElement();
        this.initialiseLiveStyles();
        Style docDefaults = this.styleDefinitionsPart.getStyleById("DocDefaults");
        this.documentDefaultPPr = docDefaults.getPPr();
        this.documentDefaultRPr = docDefaults.getRPr();
        this.addNormalToResolvedStylePPrComponent();
        this.addDefaultParagraphFontToResolvedStyleRPrComponent();
    }

    private void addNormalToResolvedStylePPrComponent() {
        Stack<PPr> pPrStack = new Stack<PPr>();
        String styleId = this.defaultParagraphStyleId;
        this.fillPPrStack(styleId, pPrStack);
        pPrStack.push(this.documentDefaultPPr);
        PPr effectivePPr = this.factory.createPPr();
        while (!pPrStack.empty()) {
            PPr pPr = pPrStack.pop();
            this.applyPPr(pPr, effectivePPr);
        }
        this.resolvedStylePPrComponent.put(styleId, effectivePPr);
    }

    private void addDefaultParagraphFontToResolvedStyleRPrComponent() {
        Stack<RPr> rPrStack = new Stack<RPr>();
        this.fillRPrStack(this.defaultParagraphStyleId, rPrStack);
        this.fillRPrStack(this.defaultCharacterStyleId, rPrStack);
        rPrStack.push(this.documentDefaultRPr);
        RPr effectiveRPr = this.factory.createRPr();
        while (!rPrStack.empty()) {
            RPr rPr = rPrStack.pop();
            this.applyRPr(rPr, effectiveRPr);
        }
        this.resolvedStyleRPrComponent.put(this.defaultCharacterStyleId, effectiveRPr);
    }

    public Style getEffectiveTableStyle(TblPr tblPr) {
        Style result;
        Stack<Style> tableStyleStack = new Stack<Style>();
        if (tblPr != null && tblPr.getTblStyle() != null) {
            String styleId = tblPr.getTblStyle().getVal();
            log.debug("Table style: " + styleId);
            this.fillTableStyleStack(styleId, tableStyleStack);
        } else {
            log.debug("No table style specified");
        }
        if (tableStyleStack.size() > 0) {
            result = (Style)XmlUtils.deepCopy(tableStyleStack.pop());
        } else {
            result = Context.getWmlObjectFactory().createStyle();
            if (tblPr == null) {
                return result;
            }
        }
        while (!tableStyleStack.empty()) {
            StyleUtil.apply((Style)tableStyleStack.pop(), result);
        }
        result.setTblPr(StyleUtil.apply(tblPr, result.getTblPr()));
        return result;
    }

    private void fillTableStyleStack(String styleId, Stack<Style> tableStyleStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error("Style definition not found: " + styleId);
            return;
        }
        tableStyleStack.push(style);
        log.debug("Added " + styleId + " to table style stack");
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is a root style.");
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            this.fillTableStyleStack(basedOnStyleName, tableStyleStack);
        } else {
            log.debug("No basedOn set for: " + style.getStyleId());
        }
    }

    public PPr getEffectivePPr(PPr expressPPr) {
        PPr effectivePPr = null;
        PPr resolvedPPr = null;
        String styleId = expressPPr == null || expressPPr.getPStyle() == null ? this.defaultParagraphStyleId : expressPPr.getPStyle().getVal();
        resolvedPPr = this.getEffectivePPr(styleId);
        if (this.hasDirectPPrFormatting(expressPPr)) {
            if (resolvedPPr == null) {
                log.warn("resolvedPPr was null. Look into this?");
                effectivePPr = Context.getWmlObjectFactory().createPPr();
            } else {
                effectivePPr = XmlUtils.deepCopy(resolvedPPr);
            }
            this.applyPPr(expressPPr, effectivePPr);
            return effectivePPr;
        }
        return resolvedPPr;
    }

    public PPr getEffectivePPr(String styleId) {
        PPr resolvedPPr = this.resolvedStylePPrComponent.get(styleId);
        if (resolvedPPr != null) {
            return resolvedPPr;
        }
        Style s = this.liveStyles.get(styleId);
        if (s == null) {
            log.error("Couldn't find style: " + styleId);
            return null;
        }
        PPr expressPPr = s.getPPr();
        if (expressPPr == null) {
            log.debug("style: " + styleId + " has no PPr");
            String normalId = this.styleDefinitionsPart.getDefaultParagraphStyle().getStyleId();
            resolvedPPr = this.resolvedStylePPrComponent.get(normalId);
            return resolvedPPr;
        }
        Stack<PPr> pPrStack = new Stack<PPr>();
        this.fillPPrStack(styleId, pPrStack);
        pPrStack.push(this.documentDefaultPPr);
        resolvedPPr = this.factory.createPPr();
        while (!pPrStack.empty()) {
            PPr pPr = pPrStack.pop();
            this.applyPPr(pPr, resolvedPPr);
        }
        this.resolvedStylePPrComponent.put(styleId, resolvedPPr);
        return resolvedPPr;
    }

    public RPr getEffectiveRPr(RPr expressRPr, PPr pPr) {
        if (pPr == null) {
            log.debug("pPr was null");
        } else {
            if (pPr.getPStyle() != null) {
                log.debug("pstyle:" + pPr.getPStyle().getVal());
                RPr pPrLevelRunStyle = this.getEffectiveRPr(pPr.getPStyle().getVal());
                return this.getEffectiveRPrUsingPStyleRPr(expressRPr, pPrLevelRunStyle);
            }
            if (expressRPr == null && pPr.getRPr() != null && this.hasDirectRPrFormatting(pPr.getRPr())) {
                return this.getEffectiveRPrUsingPStyleRPr(expressRPr, StyleUtil.apply(pPr.getRPr(), Context.getWmlObjectFactory().createRPr()));
            }
        }
        return this.getEffectiveRPrUsingPStyleRPr(expressRPr, null);
    }

    public RPr getEffectiveRPrUsingPStyleRPr(RPr expressRPr, RPr pPrLevelRunStyle) {
        log.debug("in getEffectiveRPrUsingPStyle");
        RPr effectiveRPr = null;
        effectiveRPr = pPrLevelRunStyle == null ? Context.getWmlObjectFactory().createRPr() : XmlUtils.deepCopy(pPrLevelRunStyle);
        RPr resolvedRPr = null;
        if (expressRPr != null && expressRPr.getRStyle() != null) {
            String runStyleId = expressRPr.getRStyle().getVal();
            resolvedRPr = this.getEffectiveRPr(runStyleId);
            StyleUtil.apply(resolvedRPr, effectiveRPr);
        }
        if (this.hasDirectRPrFormatting(expressRPr)) {
            StyleUtil.apply(expressRPr, effectiveRPr);
        }
        return effectiveRPr;
    }

    public RPr getEffectiveRPr(String styleId) {
        RPr resolvedRPr = this.resolvedStyleRPrComponent.get(styleId);
        if (resolvedRPr != null) {
            return resolvedRPr;
        }
        Style s = this.liveStyles.get(styleId);
        if (s == null) {
            log.error("Couldn't find style: " + styleId);
            return null;
        }
        Stack<RPr> rPrStack = new Stack<RPr>();
        this.fillRPrStack(styleId, rPrStack);
        rPrStack.push(this.documentDefaultRPr);
        resolvedRPr = this.factory.createRPr();
        while (!rPrStack.empty()) {
            RPr rPr = rPrStack.pop();
            this.applyRPr(rPr, resolvedRPr);
        }
        this.resolvedStyleRPrComponent.put(styleId, resolvedRPr);
        return resolvedRPr;
    }

    private BooleanDefaultTrue newBooleanDefaultTrue(boolean val) {
        BooleanDefaultTrue newBooleanDefaultTrue = this.factory.createBooleanDefaultTrue();
        newBooleanDefaultTrue.setVal(val);
        return newBooleanDefaultTrue;
    }

    private boolean hasDirectPPrFormatting(PPr pPrToApply) {
        if (pPrToApply == null) {
            return false;
        }
        if (pPrToApply.getKeepNext() != null) {
            return true;
        }
        if (pPrToApply.getKeepLines() != null) {
            return true;
        }
        if (pPrToApply.getPageBreakBefore() != null) {
            return true;
        }
        if (pPrToApply.getWidowControl() != null) {
            return true;
        }
        if (pPrToApply.getNumPr() != null) {
            return true;
        }
        if (pPrToApply.getSuppressLineNumbers() != null) {
            return true;
        }
        if (pPrToApply.getPBdr() != null) {
            return true;
        }
        if (pPrToApply.getShd() != null) {
            return true;
        }
        if (pPrToApply.getTabs() != null) {
            return true;
        }
        if (pPrToApply.getSpacing() != null) {
            return true;
        }
        if (pPrToApply.getInd() != null) {
            return true;
        }
        if (pPrToApply.getJc() != null) {
            return true;
        }
        if (pPrToApply.getTextAlignment() != null) {
            return true;
        }
        return pPrToApply.getOutlineLvl() != null;
    }

    protected void applyPPr(PPr pPrToApply, PPr effectivePPr) {
        log.debug("apply " + XmlUtils.marshaltoString((Object)pPrToApply, true, true) + "\n\r to " + XmlUtils.marshaltoString((Object)effectivePPr, true, true));
        if (pPrToApply == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)this.wordMLPackage, pPrToApply);
        for (Property p : properties) {
            if (p == null) continue;
            ((AbstractParagraphProperty)p).set(effectivePPr);
        }
        log.debug("result " + XmlUtils.marshaltoString((Object)effectivePPr, true, true));
    }

    private boolean hasDirectRPrFormatting(RPr rPrToApply) {
        if (rPrToApply == null) {
            return false;
        }
        if (rPrToApply.getRFonts() != null) {
            return true;
        }
        if (rPrToApply.getB() != null) {
            return true;
        }
        if (rPrToApply.getI() != null) {
            return true;
        }
        if (rPrToApply.getCaps() != null) {
            return true;
        }
        if (rPrToApply.getSmallCaps() != null) {
            return true;
        }
        if (rPrToApply.getStrike() != null) {
            return true;
        }
        if (rPrToApply.getColor() != null) {
            return true;
        }
        if (rPrToApply.getSz() != null) {
            return true;
        }
        if (rPrToApply.getHighlight() != null) {
            return true;
        }
        if (rPrToApply.getU() != null) {
            return true;
        }
        if (rPrToApply.getBdr() != null) {
            return true;
        }
        return rPrToApply.getShd() != null;
    }

    private boolean hasDirectRPrFormatting(ParaRPr rPrToApply) {
        if (rPrToApply == null) {
            return false;
        }
        if (rPrToApply.getRFonts() != null) {
            return true;
        }
        if (rPrToApply.getB() != null) {
            return true;
        }
        if (rPrToApply.getI() != null) {
            return true;
        }
        if (rPrToApply.getCaps() != null) {
            return true;
        }
        if (rPrToApply.getSmallCaps() != null) {
            return true;
        }
        if (rPrToApply.getStrike() != null) {
            return true;
        }
        if (rPrToApply.getColor() != null) {
            return true;
        }
        if (rPrToApply.getSz() != null) {
            return true;
        }
        return rPrToApply.getU() != null;
    }

    protected void applyRPr(RPr rPrToApply, RPr effectiveRPr) {
        if (rPrToApply == null) {
            return;
        }
        StyleUtil.apply(rPrToApply, effectiveRPr);
    }

    protected void applyRPr(ParaRPr rPrToApply, RPr effectiveRPr) {
        if (rPrToApply == null) {
            return;
        }
        StyleUtil.apply(rPrToApply, effectiveRPr);
    }

    private void fillPPrStack(String styleId, Stack<PPr> pPrStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            if (!styleId.equals("DocDefaults")) {
                log.error("Style definition not found: " + styleId);
            }
            return;
        }
        pPrStack.push(style.getPPr());
        log.debug("Added " + styleId + " to pPr stack");
        boolean ascertainNumId = false;
        if (style.getPPr() != null && style.getPPr().getNumPr() != null && style.getPPr().getNumPr().getNumId() == null) {
            ascertainNumId = true;
            log.debug(styleId + " ascertainNumId: " + ascertainNumId);
        } else {
            log.debug(styleId + " ascertainNumId: " + ascertainNumId);
        }
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is a root style.");
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            log.debug("Style " + styleId + " is based on " + basedOnStyleName);
            this.fillPPrStack(basedOnStyleName, pPrStack);
            Style basedOnStyle = this.liveStyles.get(basedOnStyleName);
            if (ascertainNumId && basedOnStyle != null && basedOnStyle.getPPr() != null && basedOnStyle.getPPr().getNumPr() != null && basedOnStyle.getPPr().getNumPr().getNumId() != null) {
                PPrBase.NumPr.NumId numId = basedOnStyle.getPPr().getNumPr().getNumId();
                style.getPPr().getNumPr().setNumId(numId);
                log.info("Injected numId " + numId);
            }
        } else {
            log.debug("No basedOn set for: " + style.getStyleId());
        }
    }

    private void fillRPrStack(String styleId, Stack<RPr> rPrStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error("Style definition not found: " + styleId);
            return;
        }
        rPrStack.push(style.getRPr());
        log.debug("Added " + styleId + " to rPr stack");
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is a root style.");
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            this.fillRPrStack(basedOnStyleName, rPrStack);
        } else {
            log.debug("No basedOn set for: " + style.getStyleId());
        }
    }

    private void initialiseLiveStyles() {
        log.debug("initialiseLiveStyles()");
        this.liveStyles = new HashMap<String, Style>();
        for (Style s : this.styles.getStyle()) {
            this.liveStyles.put(s.getStyleId(), s);
            log.debug("live style: " + s.getStyleId());
        }
    }

    public boolean activateStyle(String styleId) {
        if (this.liveStyles.get(styleId) != null) {
            return true;
        }
        Map<String, Style> knownStyles = StyleDefinitionsPart.getKnownStyles();
        Style s = knownStyles.get(styleId);
        if (s == null) {
            log.error("Unknown style: " + styleId);
            return false;
        }
        return this.activateStyle(s, false);
    }

    public boolean activateStyle(Style s) {
        return this.activateStyle(s, true);
    }

    private boolean activateStyle(Style s, boolean replace) {
        boolean result1;
        if (this.liveStyles.get(s.getStyleId()) != null) {
            if (!replace) {
                return false;
            }
            this.styles.getStyle().remove(this.liveStyles.get(s.getStyleId()));
        }
        this.styles.getStyle().add(s);
        this.liveStyles.put(s.getStyleId(), s);
        if (s.getBasedOn() != null) {
            String basedOn = s.getBasedOn().getVal();
            result1 = this.activateStyle(basedOn);
        } else if (s.getStyleId().equals(this.defaultParagraphStyleId) || s.getStyleId().equals(this.defaultCharacterStyleId)) {
            result1 = true;
        } else {
            log.error("Expected " + s.getStyleId() + " to have <w:basedOn ??");
            result1 = false;
        }
        boolean result2 = true;
        if (s.getLink() != null) {
            Style.Link link = s.getLink();
            result2 = this.activateStyle(link.getVal());
        }
        return result1 & result2;
    }

    public Style getStyle(String styleId) {
        return this.liveStyles.get(styleId);
    }
}

