/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import java.util.LinkedHashMap;
import java.util.Vector;

import org.docx4j.XmlUtils;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.lists.NumberingDefinition;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Shape;

public class ParagraphSet extends DocComponent implements HTML4R, PPTX4R, DOCX4R{
	
	private LinkedHashMap<Integer, Paragraph> parList;
	
	private static String SAMPLE_SHAPE_START = 
            "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\">"
            + "<p:nvSpPr>"
	            + "<p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" />"
		            + "<p:cNvSpPr>"
		                    + "<a:spLocks noGrp=\"${noGrp}\" />"
		            + "</p:cNvSpPr>"
	            + "<p:nvPr>"
                    + "<p:ph idx=\"${idx}\"/>"
	            + "</p:nvPr>"
		    + "</p:nvSpPr>"
		    + "<p:spPr>"
		      + "<a:xfrm rot=\"${rot}\">"
		        + "<a:off x=\"${offx}\" y=\"${offy}\"/>"
		        + "<a:ext cx=\"${cx}\" cy=\"${cy}\"/>"
		      + "</a:xfrm>"
		    + "</p:spPr>"
		    + "<p:txBody>"
	            + "<a:bodyPr /><a:lstStyle />";
	private static String SAMPLE_SHAPE_END = "</p:txBody>" + "</p:sp>";
	
	public ParagraphSet( ParProperties parProp ){
		super();
		setParProperties(parProp);
		parList = new LinkedHashMap<Integer, Paragraph>();
	}
	
	public ParagraphSet( ){
		super();
		parList = new LinkedHashMap<Integer, Paragraph>();
	}
	
	public void addParagraph ( Paragraph par ){
		parList.put(size(), par);
	}
	
	public int size(){
		return parList.size() ;
	}
	
	public Paragraph getLast(){
		return parList.get(size()-1);
	}
	public Paragraph get(int i){
		return parList.get(i);
	}

	
	/* used with alterFlexTable */
	public void setTextProperties(TextProperties tp){
		if( size() > 0 )
			for(int i = 0 ; i < size() ; i++ ){
				parList.get(i).setTextProperties(tp);
			}
	}


	public String toString(){
		String out = "";
		if( size() > 0 )
			for(int i = 0 ; i < size() ; i++ ){
				out += parList.get(i).toString() ;
			}
		return out;
	}


	@Override
	public String getHTML() {
		if( size() < 1 ) return "";
		String ls = getParProperties().getListStyle();

		if( ls.equals("ordered") || ls.equals("unordered") ){
			counters.add(getCSSCounterName());
			if( !numbDefinition.hasListPointer((int)list_id) ){
				numbDefinition.addListPointer((int)list_id, ls.equals("ordered") );
			}
			int pl = 0;
			if( ls.equals("ordered") )
				pl = numbDefinition.getOrdered().getLevelDefintion(getParProperties().getLevel()).getPaddingLeft();
			else pl = numbDefinition.getUnordered().getLevelDefintion(getParProperties().getLevel()).getPaddingLeft();
			getParProperties().setPaddingLeft( pl );
		} 
		
		LinkedHashMap<String, String> ppr = getParProperties().get_html_pp();
		
		String out = "";
		String elt_tag_beg = "";
		String elt_tag_end = "";

		String styleStr = "";
		
		styleStr = " style=\"" + Format.getJSString(ppr) + "\"";
		
		if( getParProperties().getListStyle().equals("ordered") || getParProperties().getListStyle().equals("unordered") ){
			elt_tag_beg = "<dl class=\"" + getCSSClassName() + " dl_reporters\"><dt" + styleStr + ">";
			elt_tag_end = "</dt></dl>";
		} else if( getParProperties().getListStyle().equals("blockquote") ){
			for( int depth = 0 ; depth < getParProperties().getLevel() ; depth ++){
				elt_tag_beg += "<blockquote>";
				elt_tag_end += "</blockquote>";
			}
		} else {
			elt_tag_beg = "<p" + styleStr + ">";
			elt_tag_end = "</p>";
		}
		for(int i = 0 ; i < size(); i++ ) parList.get(i).setHTMLReference(list_id, counters, numbDefinition);
		if( !getParProperties().getListStyle().equals("blockquote") ){
			for(int i = 0 ; i < size(); i++ ){
				out += elt_tag_beg + parList.get(i).getHTML() + elt_tag_end;
			}
		} else {
			out += elt_tag_beg;
			for(int i = 0 ; i < size(); i++ ){
				out += "<p" + styleStr + ">" + parList.get(i).getHTML() + "</p>";
			}
			out += elt_tag_end;
		}
				
		return out;
	}

	private Shape get_pptx_shape() throws Exception{
		if( !validatePPTXComponent() ) throw new Exception("class ParagraphSet: elements need to be set...");

		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("id_shape", shape_id + "" );
        mappings.put("title_shape", "Texts" + shape_id);
        mappings.put("idx", unique_id +"" );
        mappings.put("noGrp", "1" );
        mappings.put("cx", "" + getCx() );
        mappings.put("cy", "" + getCy() );
        mappings.put("offx", "" + getOffx() );
        mappings.put("offy", "" + getOffy() );
        mappings.put("rot", "" + getRot() );

        Shape o = (Shape) XmlUtils.unmarshallFromTemplate(SAMPLE_SHAPE_START + "<a:p/>" + SAMPLE_SHAPE_END, mappings,Context.jcPML, Shape.class);
        return o;
	}
	
	public Shape get_flextable_pptx() throws Exception{	
    	Shape o = get_pptx_shape();
    	o.setTxBody(get_pptx_parset());
//    	if( getParProperties().hasShadingColor() ){
//        	String color = getParProperties().getShadingColor();
//        	o.getSpPr().setSolidFill(org.lysis.reporters.pptx4r.tools.Format.getCol(color));    		
//    	}
		return o;
	}
		
	public Shape get_pptx_elt(NumberingDefinition nb, int startNumbering) throws Exception{	
    	Shape o = get_pptx_shape();
    	o.setTxBody(get_pptx_parset(nb, startNumbering));
//    	if( getParProperties().hasShadingColor() ){
//        	String color = getParProperties().getShadingColor();
//        	o.getSpPr().setSolidFill(org.lysis.reporters.pptx4r.tools.Format.getCol(color));    		
//    	}
		return o;
	}
	
	private CTTextBody get_pptx_with_rpr(CTTextParagraphProperties rpr) throws Exception{
		
		Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){

				CTTextParagraph temp = parList.get(i).getPptxTextParagraph(slidePart);
				temp.setPPr(rpr);
				out.add( temp );
			}
		}

		CTTextBody tb = new CTTextBody();
		
		CTTextBodyProperties pp = new CTTextBodyProperties();
		CTTextListStyle ls = new CTTextListStyle();
		tb.setBodyPr(pp);
		tb.setLstStyle(ls);
		
		tb.getP().addAll(out);
		return tb;
	}
	
	private CTTextBody get_pptx_no_rpr() throws Exception{
		
		Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				CTTextParagraph temp = parList.get(i).getPptxTextParagraph(slidePart);
				out.add( temp );
			}
		}

		CTTextBody tb = new CTTextBody();	
		tb.setBodyPr(new CTTextBodyProperties());
		tb.setLstStyle(new CTTextListStyle());

		
		tb.getP().addAll(out);
		return tb;
	}
	public CTTextBody get_pptx_parset() throws Exception{
		if( getParProperties() == null ) return get_pptx_no_rpr();
		
		CTTextParagraphProperties rpr = getParProperties().get_pptx_pp();
		return get_pptx_with_rpr(rpr);
	}

	public CTTextBody get_pptx_parset(NumberingDefinition nb, int startNumbering) throws Exception{
		if( getParProperties() == null ) return get_pptx_no_rpr();
		CTTextParagraphProperties rpr = getParProperties().get_pptx_pp(nb, startNumbering);
		return get_pptx_with_rpr(rpr);
	}	
	
	public boolean validateDOCXComponent(){
		if( getPPr() == null ) {
			return false;
		}

		if( ordered_num_id < 1 ) return false;
		return true;
	}

	public Vector<P> get_flextable_docx() throws Exception{
		Vector<P> out = new Vector<P>();
		
		if( !validateDOCXComponent() ) 
			throw new Exception("class ParagraphSet: elements need to be set...");

		PPr rpr = getPPr();
		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				parList.get(i).setNumberingDefinitionsPart(ndp);
				parList.get(i).setOrderedNumID(ordered_num_id);
				parList.get(i).setUnorderedNumID(unordered_num_id);
				parList.get(i).setDOCXMLPackage(getDOCXMLPackage());
				P temp = parList.get(i).getDocxParagraph();
				temp.setPPr(rpr);
				if( i == 1 ) addBookmark(temp);
				out.add( temp );
			}
		}
		return out;
	}

	private String getCSSSuffix(){
		return list_id + "-" + getParProperties().getLevel();
	}

	private String getCSSClassName(){
		if( getParProperties().getListStyle().equals("ordered") ){
			return "ol-" + getCSSSuffix();
		} else if( getParProperties().getListStyle().equals("unordered") ){
			return "ul-" + getCSSSuffix();
		} else return "";
	}
	
	public String getCSSCounterName(){
		return "counter-" + getCSSSuffix();
	}
	
	@Override
	public String getCSS() {
		return null ;
	}

	@Override
	public String getJS() {
		return null;
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}





}
