/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.lysis.reporters.docx4r.elements.PageBreak;
import org.lysis.reporters.docx4r.elements.SectionFactory;
import org.lysis.reporters.docx4r.tools.BookmarkObject;
import org.lysis.reporters.docx4r.tools.DocExplorer;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.img.DrawingML;
import org.lysis.reporters.img.Image;
import org.lysis.reporters.lists.NumberingDefinition;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.text.TOC;
import org.lysis.reporters.tools.Debug;

public class docx4R {
    private WordprocessingMLPackage basedoc;
    private NumberingDefinition numberingDefinition;
    private NumberingDefinitionsPart ndp;
    private long ordered_num_id;
    private long unordered_num_id;
    private int eltIndex = 0;
    private LinkedHashMap<String, String> styleDefinitions = new LinkedHashMap();
    private String listSeparator;
    private SectionFactory sessionFactory = new SectionFactory();
    private SectPr current_sectionPr;

    public void setListSeparator(String sep) {
        this.listSeparator = sep;
    }

    public String getListSeparator() {
        return this.listSeparator;
    }

    private void setListSeparator() {
        String sep;
        MainDocumentPart mdp = this.basedoc.getMainDocumentPart();
        this.listSeparator = sep = ((CTSettings)mdp.getDocumentSettingsPart().getJaxbElement()).getListSeparator().getVal();
    }

    private void listStyleNames() {
        Styles styles = (Styles)this.basedoc.getMainDocumentPart().getStyleDefinitionsPart().getJaxbElement();
        for (Style s : styles.getStyle()) {
            if (!s.getType().equals("paragraph")) continue;
            this.styleDefinitions.put(s.getStyleId(), s.getName().getVal());
        }
    }

    public WordprocessingMLPackage getBaseDocument() {
        return this.basedoc;
    }

    public NumberingDefinitionsPart getNumberingDefinitionsPart() {
        return this.ndp;
    }

    public long getOrderedNumID() {
        return this.ordered_num_id;
    }

    public long getUnorderedNumID() {
        return this.unordered_num_id;
    }

    public String[] getStyleNames() {
        this.listStyleNames();
        String[] stylenames = new String[this.styleDefinitions.size() * 2];
        int i = 0;
        Iterator<String> it1 = this.styleDefinitions.keySet().iterator();
        while (it1.hasNext()) {
            stylenames[i] = it1.next();
            ++i;
        }
        for (Map.Entry<String, String> entry : this.styleDefinitions.entrySet()) {
            stylenames[i] = entry.getValue();
            ++i;
        }
        return stylenames;
    }

    public int[] getSectionDimensions() {
        int[] out = new int[6];
        List sections = this.basedoc.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        out[0] = -1;
        out[1] = -1;
        out[2] = -1;
        out[3] = -1;
        out[4] = -1;
        out[5] = -1;
        if (sectPr != null) {
            out[0] = sectPr.getPgSz().getW().intValue();
            out[1] = sectPr.getPgSz().getH().intValue();
            out[2] = sectPr.getPgMar().getTop().intValue();
            out[3] = sectPr.getPgMar().getRight().intValue();
            out[4] = sectPr.getPgMar().getBottom().intValue();
            out[5] = sectPr.getPgMar().getLeft().intValue();
        }
        return out;
    }

    public void setBaseDocument(String baseDocFileName, NumberingDefinition numbDef) throws Exception {
        try {
            this.basedoc = WordprocessingMLPackage.load((InputStream)new FileInputStream(new File(baseDocFileName)));
        }
        catch (FileNotFoundException e) {
            throw new Exception("Cannot load base document [" + baseDocFileName + "]. File is not found.");
        }
        catch (Docx4JException e) {
            throw new Exception("Cannot load base document [" + baseDocFileName + "]. File is found but a Docx4J exception occured.");
        }
        this.listStyleNames();
        this.setListSeparator();
        this.sessionFactory.setPageDimensions(this.basedoc.getDocumentModel().getSections());
        this.sessionFactory.setPageBreak(false);
        this.current_sectionPr = this.sessionFactory.getOriginalSectPr();
        this.setNumberingDefinitionsPart(numbDef);
    }

    private void setNumberingDefinitionsPart(NumberingDefinition numbDef) throws Exception {
        Numbering existingNb;
        if (Debug.debug_list) {
            System.err.println("setNumberingDefinitionsPart");
        }
        this.numberingDefinition = numbDef;
        try {
            existingNb = (Numbering)this.basedoc.getMainDocumentPart().getNumberingDefinitionsPart().getJaxbElement();
        }
        catch (Exception e) {
            existingNb = new Numbering();
        }
        this.numberingDefinition.stackToExistingList(existingNb);
        if (Debug.debug_list) {
            System.err.println("stacked ");
        }
        Numbering newNumber = (Numbering)this.numberingDefinition.get_docx_elt();
        this.ndp = new NumberingDefinitionsPart();
        this.ndp.setJaxbElement((Object)newNumber);
        this.basedoc.getMainDocumentPart().addTargetPart((Part)this.ndp);
        this.ordered_num_id = this.numberingDefinition.getOrderedNumID();
        this.unordered_num_id = this.numberingDefinition.getUnorderedNumID();
        this.restartNumbering();
    }

    private void setPreviousContentWithSection(SectPr sp) {
        P p = new P();
        PPr createPPr = new PPr();
        SectPr spcopy = (SectPr)XmlUtils.deepCopy((Object)sp);
        createPPr.setSectPr(spcopy);
        p.setPPr(createPPr);
        this.basedoc.getMainDocumentPart().getContent().add(p);
        this.basedoc.getDocumentModel().refresh();
    }

    private void setEndSection(SectPr sp) {
        PPr createPPr = new PPr();
        createPPr.setSectPr(sp);
        this.basedoc.getMainDocumentPart().getContent().add(createPPr);
        this.basedoc.getDocumentModel().refresh();
    }

    private void eventManage() {
        this.sessionFactory.updateDocument(this.basedoc);
    }

    public void startSection(boolean landscape, int ncol, int bet_width, boolean breakpage) {
        this.setPreviousContentWithSection(this.current_sectionPr);
        this.sessionFactory.open();
        this.sessionFactory.setPageBreak(breakpage);
        this.sessionFactory.setColumns(ncol, bet_width);
        this.current_sectionPr = this.sessionFactory.getNewSectPr(landscape);
    }

    public void addColumnBreak() {
        if (!this.sessionFactory.isOpen() || this.sessionFactory.getCols() < 2) {
            return;
        }
        this.sessionFactory.setColumnBreak(true);
    }

    public void incrementElementIndex(int inc) {
        this.eltIndex += inc;
    }

    public int getElementIndex() {
        if (Debug.debug) {
            System.err.println("getElementIndex:" + this.eltIndex);
        }
        return this.eltIndex;
    }

    public void writeDocxToStream(String target) throws Exception {
        if (this.sessionFactory.isOpen()) {
            SectPr.Type type = new SectPr.Type();
            type.setVal("continuous");
            this.current_sectionPr.setType(type);
            this.setEndSection(this.current_sectionPr);
        }
        File f = new File(target);
        try {
            this.basedoc.save(f);
        }
        catch (Docx4JException e) {
            throw new Exception("Cannot save document [" + target + "]. A Docx4J exception occured.");
        }
    }

    public void setDocPropertyTitle(String value) {
        DocPropsCorePart docProps = this.basedoc.getDocPropsCorePart();
        CoreProperties cp = (CoreProperties)docProps.getJaxbElement();
        ObjectFactory dcElfactory = new ObjectFactory();
        SimpleLiteral literal = dcElfactory.createSimpleLiteral();
        literal.getContent().add(value);
        cp.setTitle(dcElfactory.createTitle(literal));
    }

    public void setDocPropertyCreator(String value) {
        DocPropsCorePart docProps = this.basedoc.getDocPropsCorePart();
        CoreProperties cp = (CoreProperties)docProps.getJaxbElement();
        ObjectFactory dcElfactory = new ObjectFactory();
        SimpleLiteral literal = dcElfactory.createSimpleLiteral();
        literal.getContent().add(value);
        cp.setCreator(literal);
    }

    public void deleteBookmark(String bookmark) {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            P p = bo.getP();
            ((ContentAccessor)p.getParent()).getContent().remove(p);
        }
    }

    public void deleteBookmarkNextContent(String bookmark) {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            if (((ContentAccessor)p.getParent()).getContent().size() > i + 1) {
                ((ContentAccessor)p.getParent()).getContent().remove(i + 1);
            }
        }
    }

    public void addPageBreak() throws Exception {
        ++this.eltIndex;
        this.basedoc.getMainDocumentPart().addObject((Object)PageBreak.getBreak());
    }

    public void add(Object obj) throws Exception {
        ++this.eltIndex;
        this.basedoc.getMainDocumentPart().addObject(obj);
    }

    public void add(TOC toc) throws Exception {
        toc.setDOCXMLPackage(this.basedoc);
        toc.setUID(this.eltIndex + 1);
        this.basedoc.getMainDocumentPart().getContent().add(toc.get_docx_elt());
        this.eltIndex = (int)toc.nextUniqueId();
        this.eventManage();
    }

    public void add(FlexTable dt, ParProperties pp) throws Exception {
        dt.setParProperties(pp);
        dt.setUID(this.eltIndex + 1);
        dt.setDOCXReference(this);
        Tbl tbl = dt.get_docx_elt();
        this.basedoc.getMainDocumentPart().addObject((Object)tbl);
        this.eltIndex = (int)dt.nextUniqueId();
        this.eventManage();
    }

    public void add(FlexTable dt, ParProperties pp, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (!bo.exists()) {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
        P p = bo.getP();
        dt.setParProperties(pp);
        dt.setUID(this.eltIndex + 1);
        dt.setDOCXReference(this);
        dt.set_docx_bookmark(bookmark, bo.getBookmarkID());
        Tbl tbl = dt.get_docx_elt();
        int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
        ((ContentAccessor)p.getParent()).getContent().add(i + 1, tbl);
        this.eltIndex = (int)dt.nextUniqueId();
    }

    public void add(RScript rscript, ParProperties pp) throws Exception {
        rscript.setDOCXMLPackage(this.basedoc);
        rscript.setParProperties(pp);
        rscript.setUID(this.eltIndex + 1);
        this.basedoc.getMainDocumentPart().getContent().addAll(rscript.get_docx_elt());
        this.eltIndex = (int)rscript.nextUniqueId();
        this.eventManage();
    }

    public void add(RScript rscript, ParProperties pp, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            rscript.set_docx_bookmark(bookmark, bo.getBookmarkID());
            rscript.setDOCXMLPackage(this.basedoc);
            rscript.setParProperties(pp);
            rscript.setUID(this.eltIndex + 1);
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            Object pars = rscript.get_docx_elt();
            int pid = 0;
            while (pid < rscript.size()) {
                ((ContentAccessor)p.getParent()).getContent().add(i + pid, ((Vector)pars).get(pid));
                ++pid;
            }
            this.eltIndex += rscript.size();
        } else {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
    }

    public void restartNumbering() {
        if (Debug.debug_list) {
            System.err.println("restartNumbering: " + this.ordered_num_id);
        }
        this.ordered_num_id = this.ndp.restart(this.ordered_num_id, 0L, 1L);
        if (Debug.debug_list) {
            System.err.println("unordered_num_id=" + this.unordered_num_id);
        }
    }

    public void addWithStyle(ParagraphSet par, String stylename) throws Exception {
        P p = this.basedoc.getMainDocumentPart().createStyledParagraphOfText(stylename, "");
        par.setDOCXMLPackage(this.basedoc);
        par.setPPr(p.getPPr());
        par.setUID(this.eltIndex + 1);
        if (par.size() > 0) {
            Object parset = par.get_docx_elt();
            int i = 0;
            while (i < ((Vector)parset).size()) {
                this.basedoc.getMainDocumentPart().addObject(((Vector)parset).get(i));
                ++i;
            }
        }
        this.eltIndex += par.size();
        this.eventManage();
    }

    public void addWithStyle(ParagraphSet par, String stylename, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            par.setDOCXMLPackage(this.basedoc);
            par.setPPr(stylename);
            par.setUID(this.eltIndex + 1);
            par.set_docx_bookmark(bookmark, bo.getBookmarkID());
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            Object parset = par.get_docx_elt();
            ((ContentAccessor)p.getParent()).getContent().addAll(i, parset);
            this.eltIndex += par.size();
        } else {
            System.err.println("can't find bookmark '" + bookmark + "'.");
        }
    }

    public void add(ParagraphSet par) throws Exception {
        par.setUID(this.eltIndex + 1);
        if (par.size() > 0) {
            Object parset = par.get_docx_elt();
            int i = 0;
            while (i < ((Vector)parset).size()) {
                this.basedoc.getMainDocumentPart().addObject(((Vector)parset).get(i));
                ++i;
            }
        }
        this.eltIndex += par.size();
        this.eventManage();
    }

    public void add(ParagraphSet par, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            par.setUID(this.eltIndex + 1);
            par.set_docx_bookmark(bookmark, bo.getBookmarkID());
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            Object parset = par.get_docx_elt();
            ((ContentAccessor)p.getParent()).getContent().addAll(i, parset);
            this.eltIndex += par.size();
        } else {
            System.err.println("can't find bookmark '" + bookmark + "'.");
        }
    }

    public void add(Image img, ParProperties pp) throws Exception {
        img.setDOCXMLPackage(this.basedoc);
        img.setParProperties(pp);
        img.setUID(this.eltIndex + 1);
        this.basedoc.getMainDocumentPart().addObject((Object)img.get_docx_elt());
        this.eltIndex = (int)img.nextUniqueId();
        this.eventManage();
    }

    public void add(Image img, ParProperties pp, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            P p = bo.getP();
            img.setDOCXMLPackage(this.basedoc);
            img.setParProperties(pp);
            img.setUID(this.eltIndex + 1);
            img.set_docx_bookmark(bookmark, bo.getBookmarkID());
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            img.set_docx_bookmark(bookmark, bo.getBookmarkID());
            ((ContentAccessor)p.getParent()).getContent().add(i, img.get_docx_elt());
            this.eltIndex = (int)img.nextUniqueId();
        } else {
            System.err.println("can't find bookmark '" + bookmark + "'.");
        }
    }

    public void add(DrawingML dml, ParProperties pp) throws Exception {
        dml.setDOCXMLPackage(this.basedoc);
        dml.setParProperties(pp);
        dml.setUID(this.eltIndex + 1);
        dml.setExt(dml.getWidth(), dml.getHeight());
        P altp = dml.get_docx_elt();
        this.basedoc.getMainDocumentPart().addObject((Object)altp);
        this.eltIndex += 2;
        this.eventManage();
    }

    public void add(DrawingML dml, ParProperties pp, String bookmark) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (!bo.exists()) {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
        P p = bo.getP();
        dml.setDOCXMLPackage(this.basedoc);
        dml.setParProperties(pp);
        dml.setUID(this.eltIndex + 1);
        dml.set_docx_bookmark(bookmark, bo.getBookmarkID());
        dml.setExt(dml.getWidth(), dml.getHeight());
        int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
        ((ContentAccessor)p.getParent()).getContent().remove(i);
        dml.set_docx_bookmark(bookmark, bo.getBookmarkID());
        ((ContentAccessor)p.getParent()).getContent().add(i, dml.get_docx_elt());
        this.eltIndex = (int)dml.nextUniqueId();
    }

    public void insertExternalDocx(String file) throws Exception {
        ++this.eltIndex;
        FileInputStream s2 = new FileInputStream(new File(file));
        String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        MainDocumentPart main = this.basedoc.getMainDocumentPart();
        byte[] bytes = IOUtils.toByteArray((InputStream)s2);
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(new PartName("/part" + this.eltIndex + ".docx"));
        afiPart.setContentType(new ContentType(CONTENT_TYPE));
        afiPart.setBinaryData(bytes);
        Relationship altChunkRel = main.addTargetPart((Part)afiPart);
        CTAltChunk chunk = new CTAltChunk();
        chunk.setId(altChunkRel.getId());
        main.addObject((Object)chunk);
        ++this.eltIndex;
    }

    public void insertExternalHTML(String file) throws Exception {
        ++this.eltIndex;
        FileInputStream s2 = new FileInputStream(new File(file));
        String CONTENT_TYPE = "text/html";
        MainDocumentPart main = this.basedoc.getMainDocumentPart();
        byte[] bytes = IOUtils.toByteArray((InputStream)s2);
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(new PartName("/part" + this.eltIndex + ".html"));
        afiPart.setContentType(new ContentType(CONTENT_TYPE));
        afiPart.setBinaryData(bytes);
        Relationship altChunkRel = main.addTargetPart((Part)afiPart);
        CTAltChunk chunk = new CTAltChunk();
        chunk.setId(altChunkRel.getId());
        main.addObject((Object)chunk);
        ++this.eltIndex;
    }
}

