\name{slide.layouts.pptx}
\alias{slide.layouts.pptx}
\title{Get layout names of a pptx document}
\usage{
\method{slide.layouts}{pptx}(doc, layout, ...)
}
\arguments{
  \item{doc}{Object of class \code{pptx} to extract layout
  names from.}

  \item{layout}{optional single string value, one of the
  layout names}

  \item{...}{further arguments, not used.}
}
\description{
Get layout names that exist into the template used when
pptx has been created.
}
\details{
Available names are layout names of the template document
(e.g. Title and Content , Two Content, etc.). If layout is
specified, the layout representation will be produced in a
plot. This can be useful to check available shapes.
}
\examples{
\donttest{
doc.filename = "addFlexTable_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )
# get layouts names
layouts = slide.layouts(doc)
layouts
# loop over layout names to plot each slide style
for(i in layouts ){
	slide.layouts(doc, i )
	title(sub = i )
	if( interactive() ) readline(prompt = "show next slide layout")
} 
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addSlide.pptx}},
\code{\link{slide.layouts}}
}

