package org.lysis.reporters.tools;

import java.math.BigInteger;
import java.util.Vector;

import javax.xml.bind.JAXBElement;

import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.docs.docx4R;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.lists.NumberingDefinition;

public class DocComponent {
	// bookmark for Word
	protected boolean hasBookmark;
	private JAXBElement<CTBookmark> bmStart;
	private JAXBElement<CTMarkupRange> bmEnd;

	// necessary refs for PPTX
	protected PresentationMLPackage pptx_mlp;
	protected SlidePart slidePart;
	
	// necessary refs for DOCX
	protected WordprocessingMLPackage docx_mlp;
	protected NumberingDefinitionsPart ndp;
	protected long ordered_num_id;
	protected long unordered_num_id;

	private long cx;
	private long cy;
	private long offx;
	private long offy;
	
	private ParProperties parProp;
	private PPr inherited_ppr;

	protected long unique_id;
	
	protected long shape_id;
	
	protected long list_id;
	protected NumberingDefinition numbDefinition;
	protected Vector<String> counters;

	public DocComponent(){
		hasBookmark = false;
		unique_id = -1;
		shape_id = -1;
		cx = -1;
		cy = -1;
		offx = -1;
		offy = -1;
		parProp = null;
		inherited_ppr = null;
		docx_mlp = null;
		pptx_mlp = null;
		slidePart = null;
		
		list_id = -1;
	}
	public long getCx() {
		return cx;
	}
	public long getCy() {
		return cy;
	}
	public long getOffx() {
		return offx;
	}
	public long getOffy() {
		return offy;
	}
	
	public boolean validatePPTXComponent(){
		if( offx < 0 ) return false;
		if( cx < 0 ) return false;
		if( offy < 0 ) return false;
		if( cy < 0 ) return false;
		if( unique_id < 0 ) return false;
		if( shape_id < 0 ) return false;
		if( pptx_mlp == null ) return false;
		if( slidePart == null) return false;
		return true;
	}
	
	public boolean validateDOCXComponent(){
		if( unique_id < 0 ) {
			if( Debug.debug) System.err.println("unique_id is missing");
			return false;
		}
		if( docx_mlp == null ) {
			if( Debug.debug) System.err.println("docx_mlp is missing");
			return false;
		}

		if( inherited_ppr == null && parProp == null ) {
			if( Debug.debug) System.err.println("inherited_ppr == null && parProp == null is missing");
			return false;
		}
		return true;
	}
	
	public void set_docx_bookmark(String bookmark, BigInteger bookmarkID){
		hasBookmark = true;
		
		org.docx4j.wml.ObjectFactory factory = org.docx4j.jaxb.Context.getWmlObjectFactory();
		CTBookmark bm = new CTBookmark();
		bm.setId(bookmarkID);
		bm.setName(bookmark);		
		bmStart =  factory.createBodyBookmarkStart(bm);

		CTMarkupRange mr = factory.createCTMarkupRange();
		mr.setId(bookmarkID);
		bmEnd = factory.createBodyBookmarkEnd(mr);
	}
	
	public void addBookmark(P paragraph){
		if( hasBookmark ) paragraph.getContent().add(bmStart);
		if( hasBookmark ) paragraph.getContent().add(bmEnd);	
	}
	
	public void setExt(long w, long h){
		cx = w;
		cy = h;
	}
	public void setExtCx(long w){
		cx = w;
	}
	public void setExtCy(long h){
		cy = h;
	}
	
	public void setOff(long x, long y){
		offx = x;
		offy = y;
	}
	public void setOffx(long x){
		offx = x;
	}
	public void setOffy(long y){
		offy = y;
	}
	
	public void setOffAndExt(long x, long y, long w, long h){
		cx = w;
		cy = h;
		offx = x;
		offy = y;
	}
	
	public void setHTMLReference(long lid, Vector<String> counters, NumberingDefinition nb ){
		this.list_id = lid;
		this.counters = counters;
		this.numbDefinition = nb;
	}

	public WordprocessingMLPackage getDOCXMLPackage(){
		return docx_mlp;
	}
	
	public void setNumberingDefinitionsPart(NumberingDefinitionsPart ndp){
		this.ndp = ndp;
	}
	
	public void setOrderedNumID(long ordered_num_id){
		this.ordered_num_id = ordered_num_id;
	}
	
	public void setUnorderedNumID(long unordered_num_id){
		this.unordered_num_id = unordered_num_id;
	}
	
	public void setDOCXReference(NumberingDefinitionsPart ndp, long ordered_num_id, long unordered_num_id){
		this.ndp = ndp;
		this.ordered_num_id = ordered_num_id;
		this.unordered_num_id = unordered_num_id;
	}
	
	public void setDOCXReference( docx4R doc){
		
		docx_mlp = doc.getBaseDocument();
		ndp = doc.getNumberingDefinitionsPart();
		ordered_num_id = doc.getOrderedNumID();
		unordered_num_id = doc.getUnorderedNumID();
		getParProperties().setOrderedNumid(ordered_num_id);
		getParProperties().setUnorderedNumid(unordered_num_id);		
	}
	
	public void setDOCXMLPackage( WordprocessingMLPackage mlpack ){
		docx_mlp = mlpack;
	}
	public void setPPTXMLPackage( PresentationMLPackage mlpack ){
		pptx_mlp = mlpack;
	}
	public void setPPTXSlidePart( SlidePart sp ){
		slidePart = sp;
	}
	public void setParProperties( ParProperties pp ){
		parProp = pp;
	}
	public void setPPr( PPr pp ){
		inherited_ppr = pp;
	}
	public void setPPr( String style ){
		P p = docx_mlp.getMainDocumentPart().createStyledParagraphOfText(style, "");
		inherited_ppr = p.getPPr();
	}
	
	public void setUID( long uid ){
		unique_id = uid;
	}
	public void setShapeID( long id ){
		shape_id = id;
	}
	public CTTransform2D getXfrm(){
		org.docx4j.dml.ObjectFactory dmlFactory = new org.docx4j.dml.ObjectFactory();
		org.docx4j.dml.CTTransform2D xfrm = dmlFactory.createCTTransform2D();
		CTPositiveSize2D ext = dmlFactory.createCTPositiveSize2D();
		ext.setCx(cx);
		ext.setCy(cy);
		xfrm.setExt(ext);
		CTPoint2D off = dmlFactory.createCTPoint2D();
		xfrm.setOff(off);
		off.setX(offx);
		off.setY(offy);
		return xfrm;
	}
	
	public PPr getPPr(){
		if( inherited_ppr == null ) return parProp.get_docx_pp();
		else return inherited_ppr;
	}
	
	public ParProperties getParProperties(){
		return parProp;
	}
	
	public double width(){
		return EMU.getInchFromEMU( cx );
	}
	public double height(){
		return EMU.getInchFromEMU( cy );
	}
		
	public void setXfrm( CTTransform2D xfrm){

		offx = xfrm.getOff().getX();
		offy = xfrm.getOff().getY();
		cx = xfrm.getExt().getCx();
		cy = xfrm.getExt().getCy();		
		if(Debug.debug) System.err.println("setXfrm > offx " + offx + 
				" offy " + offy + " cx " + cx + 
				" cy " + cy );
	}
	
	public long nextUniqueId(){
		return unique_id+1;
	}

}
