package org.lysis.reporters.docx4r.elements;

import java.math.BigInteger;
import java.util.List;

import org.docx4j.XmlUtils;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTColumns;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STPageOrientation;
import org.docx4j.wml.SectPr;

public class SectionFactory {
	
	private BigInteger pageWidth;

	private BigInteger pageHeight;
	
	private int cols;
	
	private int between_width;
	
	private boolean do_column_break;
	private boolean page_break;
	
	private boolean is_open;

	private SectPr sectPr;
	public SectionFactory( ){
		pageWidth = null;
		pageHeight = null;
		is_open = false;
		cols = 1;
		between_width = 0;
		do_column_break = false;
		page_break = false;
	}
	
	public void setPageBreak( boolean b ){
		page_break = b;

	}
	public boolean getPageBreak(  ){
		return page_break;

	}
	public void open(){
		is_open = true;

	}
	public void close(){
		is_open = false;
	}
	
	public boolean isOpen(){
		return is_open;
	}
	public int getCols(){
		return cols;
	}
	public void setColumns( int c, int w){
		cols = c;
		between_width = w;
	}
	public void setColumnBreak(boolean cb){
		do_column_break = cb;
	}
	
	public void updateDocument(WordprocessingMLPackage basedoc){
	
		if( do_column_break ){
			int sz = basedoc.getMainDocumentPart().getContent().size();
			Object last_obj = basedoc.getMainDocumentPart().getContent().get(sz-1);
			
			Br br = new Br();
			br.setType(STBrType.COLUMN); 

			if(last_obj.getClass().equals(org.docx4j.wml.Tbl.class)){
				last_obj = basedoc.getMainDocumentPart().getContent().get(sz-2);
				if(last_obj.getClass().equals(org.docx4j.wml.P.class)){
					((P)last_obj).getContent().add(br);
				} else System.err.println("cannot add a column break because previous object is also a table.");
			} else if(last_obj.getClass().equals(org.docx4j.wml.P.class)){
				((P)last_obj).getContent().add(0,br);
			}  
			
			do_column_break = false;
		}
	}
	
	
	public static P getBreakColumn(){
		P p = new P();
		R r = new R();
		R.LastRenderedPageBreak pp = new R.LastRenderedPageBreak();
		r.getContent().add(pp);
		p.getContent().add(r);
		return p;
		
	}
	public void setPageDimensions(List<SectionWrapper> sections){

		sectPr = XmlUtils.deepCopy(sections.get(sections.size() - 1).getSectPr());
		
		pageWidth = sectPr.getPgSz().getW();
		pageHeight = sectPr.getPgSz().getH();
	}
	
	public SectPr getNewSectPr(boolean landscape){
		
        SectPr newSectPr = XmlUtils.deepCopy(sectPr);
        
        if( landscape ) {
        	newSectPr.getPgSz().setOrient(STPageOrientation.LANDSCAPE);
        	if( pageWidth.intValue() > pageHeight.intValue() ) {
        		newSectPr.getPgSz().setH(pageHeight);
        		newSectPr.getPgSz().setW(pageWidth);
        	} else {
        		newSectPr.getPgSz().setH(pageWidth);
        		newSectPr.getPgSz().setW(pageHeight);
        	}
        } else {
        	newSectPr.getPgSz().setOrient(STPageOrientation.PORTRAIT);
        	if( pageWidth.intValue() > pageHeight.intValue() ) {
        		newSectPr.getPgSz().setH(pageWidth);
        		newSectPr.getPgSz().setW(pageHeight);
        	} else {
        		newSectPr.getPgSz().setH(pageHeight);
        		newSectPr.getPgSz().setW(pageWidth);
        	}
        }
       
        
        CTColumns ctcols = new CTColumns();
        ctcols.setNum(BigInteger.valueOf(cols));
        ctcols.setSpace(BigInteger.valueOf(between_width));
        newSectPr.setCols(ctcols);

        if( !page_break ){
        	SectPr.Type type = new SectPr.Type();
        	type.setVal("continuous");
        	newSectPr.setType(type);
        } 
        
    	return newSectPr;
	}

	public SectPr getOriginalSectPr(){
        SectPr newSectPr = XmlUtils.deepCopy(sectPr);
    	return newSectPr;
	}

}
