/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.lysis.reporters.html4r.elements.DataTable;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.html4r.elements.MenuBar;
import org.lysis.reporters.html4r.elements.RScript;
import org.lysis.reporters.html4r.elements.SetOfPlots;
import org.lysis.reporters.html4r.elements.SetOfPot;
import org.lysis.reporters.html4r.elements.SetOfRaphaelPlots;
import org.lysis.reporters.html4r.elements.TOC;
import org.lysis.reporters.html4r.elements.Title;
import org.lysis.reporters.tables.FlexTable;

public class HTMLPageContent {
    public static int error = 0;
    public static int noproblem = 1;
    public static int fileproblem = 2;
    private TOC titles;
    private String title;
    private MenuBar mb;
    private LinkedHashMap<Integer, HTML4R> content;
    private int ncontent;
    private String charset;
    private Vector<String> cssfiles;
    private Vector<String> jsfiles;
    private Vector<String> jscodes;
    private Vector<String> csscodes;

    public HTMLPageContent(String title, String charset) throws IOException {
        this.title = title;
        this.titles = new TOC(this.title);
        this.content = new LinkedHashMap();
        this.ncontent = 0;
        this.setCharset(charset);
        this.cssfiles = new Vector();
        this.jsfiles = new Vector();
        this.jscodes = new Vector();
        this.csscodes = new Vector();
    }

    private int addHTML4R(HTML4R elt) {
        if (elt instanceof Title) {
            this.titles.addTitle((Title)elt);
        }
        this.content.put(this.ncontent, elt);
        if (elt.hasJS()) {
            this.jscodes.add(elt.getJS());
        }
        if (elt.hasCSS()) {
            this.csscodes.add(elt.getCSS());
        }
        ++this.ncontent;
        return noproblem;
    }

    public int add(Title elt) {
        return this.addHTML4R(elt);
    }

    public int add(DataTable elt) {
        return this.addHTML4R(elt);
    }

    public int add(FlexTable elt) {
        return this.addHTML4R(elt);
    }

    public int add(SetOfPot elt) {
        return this.addHTML4R(elt);
    }

    public int add(SetOfPlots elt) {
        return this.addHTML4R(elt);
    }

    public int add(SetOfRaphaelPlots elt) {
        return this.addHTML4R(elt);
    }

    public int add(RScript elt) {
        return this.addHTML4R(elt);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void addStylesheet(String file) {
        if (!this.cssfiles.contains(file)) {
            this.cssfiles.add(file);
        }
    }

    public void addJavascript(String file) {
        if (!this.jsfiles.contains(file)) {
            this.jsfiles.add(file);
        }
    }

    private String getStylesheets() {
        String out = "";
        int i = 0;
        while (i < this.cssfiles.size()) {
            out = String.valueOf(out) + "<link rel=\"stylesheet\" href=\"" + this.cssfiles.get(i) + "\" type=\"text/css\" media=\"all\" />";
            ++i;
        }
        return out;
    }

    private String getScripts() {
        String out = "";
        int i = 0;
        while (i < this.jsfiles.size()) {
            out = String.valueOf(out) + "<script type=\"text/javascript\" src=\"" + this.jsfiles.get(i) + "\"></script>";
            ++i;
        }
        return out;
    }

    public void setMenuBar(MenuBar mb) throws IOException {
        this.mb = mb;
    }

    public void setActiveMenuBarTitle(String title) throws IOException {
        this.mb.setActiveTitle(title);
    }

    public String getHead() {
        String out = "";
        out = String.valueOf(out) + "<head>";
        out = String.valueOf(out) + "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />";
        out = String.valueOf(out) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.charset + "\" />";
        out = String.valueOf(out) + "<title>" + this.title + "</title>";
        out = String.valueOf(out) + "<meta name=\"format-detection\" content=\"telephone=no\" />";
        out = String.valueOf(out) + this.getStylesheets();
        out = String.valueOf(out) + this.getScripts();
        int i = 0;
        while (i < this.csscodes.size()) {
            out = String.valueOf(out) + "<style type=\"text/css\">";
            out = String.valueOf(out) + this.csscodes.get(i);
            out = String.valueOf(out) + "</style>";
            ++i;
        }
        out = String.valueOf(out) + "</head>";
        return out;
    }

    public String getJSCode() {
        String out = "";
        out = String.valueOf(out) + "<script type=\"text/javascript\">";
        int i = 0;
        while (i < this.jscodes.size()) {
            out = String.valueOf(out) + this.jscodes.get(i);
            ++i;
        }
        out = String.valueOf(out) + "</script>";
        return out;
    }

    public String getBody(int index) {
        return this.content.get(index).getHTML();
    }

    public int writeHtml(String target) throws IOException {
        BufferedWriter output;
        File f = new File(target);
        try {
            output = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException e) {
            return fileproblem;
        }
        if (this.titles.hasJS()) {
            this.jscodes.add(this.titles.getJS());
        }
        output.write("<!DOCTYPE html>");
        output.write("<html>");
        output.write(this.getHead());
        output.write("<body>");
        output.write("<div class=\"container bs-docs-container\">");
        output.write("<div class=\"row\">");
        output.write("<div class=\"col-md-3\" id=\"navbar-div\">");
        output.write(this.titles.getHTML());
        output.write("</div>");
        output.write("<div class=\"col-md-9\" data-spy=\"scroll\" data-target=\"#navbar-div\">");
        int i = 0;
        while (i < this.ncontent) {
            HTML4R elt_output = this.content.get(i);
            if (elt_output.hasHTML()) {
                output.write(elt_output.getHTML());
            }
            ++i;
        }
        output.write("</div>");
        output.write("</div>");
        output.write("</div>");
        output.write(this.mb.getHTML());
        output.write(this.getJSCode());
        output.write("</body>");
        output.write("</html>");
        output.close();
        return noproblem;
    }
}

