% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothRatio.R
\name{smoothRatio}
\alias{smoothRatio}
\title{A function to smooth ratio values using cubic smoothing spline
smoothRatio function splits values from 'ratio' column by chromosome and based the supplied
'groupMin' and 'split' parameters and then applies smooth.spline() function from R stats package.
The supplied dataframe may contain multiple ratios, i.e. ratios produced using multiple replicating
samples and/or multiple non-replicating samples. This must be reflected in 'name.rep' and 'name.nonRep'
columns. In other words, different ratio dataframes may be merged using rbind() function before calling
smoothRatio() function.}
\usage{
smoothRatio(ratioDF, groupMin = 5, splitNum = 5)
}
\arguments{
\item{ratioDF}{A ratio dataframe or combined ratios dataframe containing 'ratio' column (dataframe).}

\item{groupMin}{Minimum number of values required to make a group (integer, defaults to 5).}

\item{splitNum}{Minimum number of adjacent bins with missing values to close current group (integer, defaults to 5).}
}
\description{
A function to smooth ratio values using cubic smoothing spline
smoothRatio function splits values from 'ratio' column by chromosome and based the supplied
'groupMin' and 'split' parameters and then applies smooth.spline() function from R stats package.
The supplied dataframe may contain multiple ratios, i.e. ratios produced using multiple replicating
samples and/or multiple non-replicating samples. This must be reflected in 'name.rep' and 'name.nonRep'
columns. In other words, different ratio dataframes may be merged using rbind() function before calling
smoothRatio() function.
}
\examples{
ratioDF <- smoothRatio(W303norm)
}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{replication}
\keyword{spline}
