% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_to_rga.R
\name{weibull_to_rga}
\alias{weibull_to_rga}
\title{Weibull to RGA}
\usage{
weibull_to_rga(failures, suspensions = NULL)
}
\arguments{
\item{failures}{A vector of failure times.}

\item{suspensions}{A vector of suspension (censoring) times.}
}
\value{
A data frame with times and failure counts suitable for reliability growth analysis.
}
\description{
This function converts Weibull data (failure and suspension times) into a format
suitable for reliability growth analysis (RGA).
}
\examples{
failures <- c(100, 200, 200, 400)
suspensions <- c(250, 350, 450)
result <- weibull_to_rga(failures, suspensions)
print(result)
}
