% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rga.R
\name{plot_rga}
\alias{plot_rga}
\title{Plot Reliability Growth Analysis Results}
\usage{
plot_rga(
  rga_obj,
  point_col = "black",
  line_col = "black",
  xlab = "Cumulative Time",
  ylab = "Cumulative Failures",
  main = "Reliability Growth Analysis",
  conf_bounds = TRUE,
  legend = TRUE,
  log = FALSE
)
}
\arguments{
\item{rga_obj}{An object of class \code{rga}, which contains the results from the RGA model.}

\item{point_col}{Color for the data points (default: "black").}

\item{line_col}{Color for the fitted line (default: "black").}

\item{xlab}{Label for the x-axis (default: "Cumulative Time").}

\item{ylab}{Label for the y-axis (default: "Cumulative Failures").}

\item{main}{Title for the plot (default: "Reliability Growth Analysis").}

\item{conf_bounds}{Logical indicating whether to include confidence bounds (default: TRUE).}

\item{legend}{Logical indicating whether to show the legend (default: TRUE).}

\item{log}{Logical indicating whether to use a log-log scale (default: FALSE).}
}
\value{
The function does not return a value.
}
\description{
This function generates a plot for the results of a Reliability Growth Analysis (RGA).
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
result <- rga(times, failures)
plot_rga(result)
}
