% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridworld.R
\name{sampleGridSequence}
\alias{sampleGridSequence}
\title{Sample grid sequence}
\usage{
sampleGridSequence(N, actionSelection = "random", control = list(alpha
  = 0.1, gamma = 0.1, epsilon = 0.1), model = NULL, ...)
}
\arguments{
\item{N}{Number of samples.}

\item{actionSelection}{(optional) Defines the action selection mode of the reinforcement learning agent. Default: \code{random}.}

\item{control}{(optional) Control parameters defining the behavior of the agent.
Default: \code{alpha = 0.1}; \code{gamma = 0.1}; \code{epsilon = 0.1}.}

\item{model}{(optional) Existing model of class \code{rl}. Default: \code{NULL}.}

\item{...}{Additional parameters passed to function.}
}
\value{
An \code{dataframe} containing the experienced state transition tuples \code{s,a,r,s_new}.
The individual columns are as follows:
\describe{
  \item{\code{State}}{The current state.}
  \item{\code{Action}}{The selected action for the current state.}
  \item{\code{Reward}}{The reward in the current state.}
  \item{\code{NextState}}{The next state.}
}
}
\description{
Function uses an environment function to generate sample experience in the form of state transition tuples.
}
\seealso{
\code{\link{gridworldEnvironment}}

\code{\link{ReinforcementLearning}}
}
