% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_thread_urls.R
\name{find_thread_urls}
\alias{find_thread_urls}
\title{Find Reddit thread URLs}
\usage{
find_thread_urls(
  keywords = NA,
  sort_by = "top",
  subreddit = NA,
  period = "month"
)
}
\arguments{
\item{keywords}{A optional string that you want to search for, e.g. "cute kittens".
If NA, then either your front page will be searched or the front page of a specified subreddit}

\item{sort_by}{A string representing how you want Reddit to sort the results.
Note that this string is conditional on whether you are searching by keywords or not.
If you are searching by keywords, then it must be one of: relevance, comments, new, hot, top;
if you are not searching by keywords, then it must be one of: hot, new, top, rising}

\item{subreddit}{(optional) A string representing the subreddit of interest}

\item{period}{A string representing the period of interest (hour, day, week, month, year, all)}
}
\value{
a data frame with URLs to Reddit threads that are relevant to your input parameters
}
\description{
Find URLs to reddit threads of interest.
There are 2 available search strategies: by keywords and by home page. Using a set of keywords
Can help you narrow down your search to a topic of interest that crosses multiple subreddits
whereas searching by home page can help you find, for example, top posts within a specific subreddit
}
\examples{
\dontrun{
find_thread_urls(keywords="cute kittens", subreddit="cats", sort_by="new", period="month")
find_thread_urls(subreddit="cats", sort_by="rising", period="all")
}
}
